%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define _name gnome-desktop
%define ver_major 44
%define beta %nil
%define api_ver 3.0
%define api_ver4 4.0
%define gnome_date "%(date "+%%B %%e %%Y"), Moscow"

%def_enable gtk4
%def_enable legacy_library
%def_enable gtk_doc
%def_enable introspection
%def_enable installed_tests
%def_enable udev
%def_disable check
# seccomp isn't currently supported on all the Linux architectures
%def_enable libseccomp

Name: %{_name}3
Version: %ver_major.4
Release: alt1%beta

Summary: Library with common API for various GNOME 3 modules
License: GPL-2.0 and LGPL-2.0
Group: Graphical desktop/GNOME
Url: http://www.gnome.org

Vcs: https://gitlab.gnome.org/GNOME/gnome-desktop.git

%if_disabled snapshot
Source: %gnome_ftp/%_name/%ver_major/%_name-%version%beta.tar.xz
%else
Source: %_name-%version%beta.tar
%endif
# add e2k to list of libseccomp incompatible cpus
Patch: gnome-desktop-40.3-alt-e2k.patch

Obsoletes: %_name
Provides: %_name = %version-%release

%define glib_ver 2.54.0
%define gdk_pixbuf_ver 2.36.5
%define gtk3_ver 3.3.6
%define gtk4_ver 4.4.0
%define gsds_ver 3.28.0

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-build-gir
BuildRequires: meson yelp-tools
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgdk-pixbuf-devel >= %gdk_pixbuf_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: iso-codes-devel
BuildRequires: xkeyboard-config-devel libxkbcommon-devel
BuildRequires: libXrandr-devel >= 1.3 libXext-devel >= 1.1
BuildRequires: libudev-devel pkgconfig(systemd)
%{?_enable_legacy_library:BuildRequires: libgtk+3-devel >= %gtk3_ver}
%{?_enable_gtk4:BuildRequires: libgtk4-devel >= %gtk4_ver}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_libseccomp:BuildRequires: libseccomp-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel %{?_enable_legacy_library:libgtk+3-gir-devel}
BuildRequires: %{?_enable_gtk4:libgtk4-gir-devel} gsettings-desktop-schemas-gir-devel}

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.  GNOME is similar in purpose and scope
to CDE and KDE, but GNOME is based completely on free software. The

GNOME Desktop provides the core libraries for the gnome desktop.

%package -n lib%name
Summary: GNOME desktop core libraries
Group: Graphical desktop/GNOME
License: LGPL-2.0
Requires: icon-theme-hicolor
Requires: udev-hwdb
Requires: bubblewrap
Requires: pciids usbids

%description -n lib%name
Gnome 3 desktop libraries.

%package -n lib%name-devel
Summary: GNOME 3 desktop development libraries and includes
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release
License: LGPL-2.0 and FDL-1.1

%description -n lib%name-devel
Gnome 3 desktop libraries and header files for creating GNOME applications.

%package -n lib%name-devel-doc
Summary: GNOME 3 desktop development documentation
Group: Development/Documentation
Conflicts: lib%name-devel < %version
License: LGPL-2.0 and FDL-1.1
BuildArch: noarch

%description -n lib%name-devel-doc
Development documentation for Gnome 3 desktop library.

%if_enabled static
%package -n lib%name-devel-static
Summary: GNOME 3 desktop develop libraries and includes
Group: Development/GNOME and GTK+
Requires: lib%name-devel = %version-%release
License: LGPL-2.0

%description -n lib%name-devel-static
Gnome 3 desktop static libraries for creating GNOME applications.
%endif

%package -n lib%name-gir
Summary: GObject introspection data for the %_name library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the %_name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %_name
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the %_name library

%package tests
Summary: Tests for the Gnome 3 desktop library
Group: Development/Other
Requires: lib%name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the Gnome 3 desktop library.


%prep
%setup -n %_name-%version%beta
%ifarch %e2k
%patch -p1 -b .e2k
%endif

%build
%meson \
    %{?_disable_legacy_library:-Dlegacy_library=false} \
    %{?_disable_gtk4:-Dgtk4=false} \
    %{?_enable_gtk_doc:-Dgtk_doc=true} \
    %{?_enable_installed_tests:-Dinstalled_tests=true} \
    %{?_enable_udev:-Dudev=enabled}
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%_name.lang %_name-%api_ver gpl lgpl fdl

%check
%__meson_test

#%files

%files -n lib%name -f %_name.lang
%{?_enable_legacy_library:%_libdir/lib%_name-3.so.*}
%{?_enable_gtk4:
%_libdir/lib%_name-4.so.*
%_libdir/libgnome-bg-4.so.*
%_libdir/libgnome-rr-4.so.*}
%doc AUTHORS NEWS README*

%files -n lib%name-devel
%{?_enable_legacy_library:
%_libexecdir/%_name-debug/
%_includedir/%_name-%api_ver
%_libdir/lib%_name-3.so
%_pkgconfigdir/%_name-%api_ver.pc}
%{?_enable_gtk4:
%_includedir/%_name-4.0
%_libdir/libgnome-bg-4.so
%_libdir/lib%_name-4.so
%_libdir/libgnome-rr-4.so
#%_datadir/gnome/gnome-version.xml
%_pkgconfigdir/gnome-bg-4.pc
%_pkgconfigdir/%_name-4.pc
%_pkgconfigdir/gnome-rr-4.pc}

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files -n lib%name-gir
%{?_enable_legacy_library:%_typelibdir/GnomeDesktop-%api_ver.typelib}
%{?_enable_gtk4:
%_typelibdir/GnomeBG-4.0.typelib
%_typelibdir/GnomeDesktop-4.0.typelib
%_typelibdir/GnomeRR-4.0.typelib}

%files -n lib%name-gir-devel
%{?_enable_legacy_library:%_girdir/GnomeDesktop-%api_ver.gir}
%{?_enable_gtk4:
%_girdir/GnomeBG-4.0.gir
%_girdir/GnomeDesktop-4.0.gir
%_girdir/GnomeRR-4.0.gir}
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name/
%_datadir/installed-tests/%_name/
%endif


%changelog
