%def_disable snapshot
%define optflags_lto %nil

%define _libexecdir %_prefix/libexec
%define _name control-center
%define ver_major 49
%define beta %nil
%define api_ver 2.0
%define xdg_name org.gnome.Settings

%define gxdp_ver e68375c

%def_disable debug
%def_enable x11
%def_enable bluetooth
%def_enable snap
%def_enable malcontent
%def_enable doc
%def_enable check

Name: gnome-control-center
Version: %ver_major.1
Release: alt1%beta

Summary: GNOME Control Center
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://www.gnome.org

Vcs: https://gitlab.gnome.org/GNOME/libgnome-volume-control.git

%if_enabled snapshot
Source: %name-%version%beta.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%endif
Source1: https://raw.githubusercontent.com/eggert/tz/main/zone.tab
%{?_enable_snapshot:Source10: libgxdp-%gxdp_ver.tar}
# merged for gnome-50 (f32559f)
#Patch10: 

%define glib_ver 2.76.6
%define gtk4_ver 4.17.5
%define adwaita_ver 1.8
%define desktop_ver 43
%define fontconfig_ver 1.0.0
%define gsds_ver %ver_major
# nm_client_get_permissions_state()
%define nm_ver 1.52
%define goa_ver 3.51.0
%define acc_ver 23.11.69
%define sett_daemon_ver 48
%define bt_api_ver 3.0
%define bt_ver 42
%define systemd_ver 40
%define wacom_ver 0.7
%define ibus_ver 1.5.2
%define colord_ver 1.0
%define pwq_ver 1.2.2
%define upower_ver 1.90.6
%define grilo_ver 0.3.0
%define polkit_ver 0.114
%define snapd_ver 1.62
%define malcontent_ver 0.11.0
%define gudev_ver 232
%define pulse_ver 2.0
%define cups_ver 1.4

Requires: %name-data = %EVR

# For /usr/share/gnome
Requires: gnome-filesystem
Requires: gnome-settings-daemon >= %sett_daemon_ver
# for graphical passwd changing apps
Requires: accountsservice >= %acc_ver
Requires: cups-pk-helper
Requires: geoclue2
Requires: shadow-utils
Requires: setxkbmap
Requires: fwupd
Requires: gnome-online-accounts >= %goa_ver
Requires: gnome-bluetooth%bt_api_ver
# for VPN
Requires: NetworkManager-openvpn-gtk4
Requires: NetworkManager-pptp-gtk4
Requires: NetworkManager-vpnc-gtk4
Requires: NetworkManager-l2tp-gtk4
Requires: NetworkManager-openconnect-gtk4

# for sharing
Requires: gnome-user-share
# for media sharing
Requires: rygel
# for desktop sharing
Requires: gnome-remote-desktop
# for power management
Requires: power-profiles-daemon
# GPU detection
Requires: switcheroo-control

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson blueprint-compiler
BuildRequires: desktop-file-utils gtk-doc xsltproc /usr/bin/appstreamcli
BuildRequires: fontconfig-devel >= %fontconfig_ver
BuildRequires: libgtk4-devel >= %gtk4_ver
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: pkgconfig(gnome-desktop-4) pkgconfig(gnome-bg-4)
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: gnome-settings-daemon-devel >= %sett_daemon_ver
BuildRequires: libcolord-devel >= %colord_ver pkgconfig(colord-gtk4)
BuildRequires: libibus-devel >= %ibus_ver libxkbfile-devel setxkbmap
BuildRequires: libupower-devel >= %upower_ver libpolkit1-devel >= %polkit_ver
BuildRequires: libgio-devel librsvg-devel libxml2-devel
BuildRequires: libgtop-devel libcups-devel >= %cups_ver
BuildRequires: libpulseaudio-devel >= %pulse_ver iso-codes-devel
BuildRequires: libpwquality-devel >= %pwq_ver libkrb5-devel libsmbclient-devel
BuildRequires: gobject-introspection-devel libgtk4-gir-devel
# for test-endianess
BuildRequires: glibc-i18ndata
BuildRequires: libnm-devel >= %nm_ver libmm-glib-devel pkgconfig(libnma-gtk4) pkgconfig(gcr-4)
BuildRequires: libgnome-online-accounts-devel >= %goa_ver
BuildRequires: libaccountsservice-devel >= %acc_ver
BuildRequires: libwacom-devel >= %wacom_ver
BuildRequires: pkgconfig(systemd) >= %systemd_ver
BuildRequires: libgrilo-devel >= %grilo_ver
BuildRequires: libsecret-devel libgnutls-devel
BuildRequires: libudisks2-devel
BuildRequires: tecla-devel
%{?_enable_x11:BuildRequires: libX11-devel libXi-devel}
%{?_enable_bluetooth:BuildRequires: pkgconfig(gnome-bluetooth-ui-%bt_api_ver) >= %bt_ver}
%{?_enable_snap:BuildRequires: pkgconfig(snapd-glib-2) >= %snapd_ver}
%{?_enable_malcontent:BuildRequires: pkgconfig(malcontent-0) >= %malcontent_ver}
BuildRequires: libgudev-devel >= %gudev_ver libgsound-devel
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: libepoxy-devel
%{?_enable_check:BuildRequires: python3(dbusmock)}

%description
GNOME (the GNU Network Object Model Environment) is an attractive and
easy-to-use GUI desktop environment. The control-center package
provides the GNOME Control Center utilities that allow you to setup
and configure your system's GNOME environment (things like the desktop
background and theme, the screensaver, the window manager, system
sounds, and mouse behavior).

If you install GNOME, you need to install control-center.

%package data
Summary: Arch independent files for GNOME Control Center
Group: Networking/Instant messaging
BuildArch: noarch

%description data
This package provides noarch data needed for GNOME Control Center to work.

%package devel
Summary: GNOME Control Center development files
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name = %EVR

%description devel
If you're interested in developing panels for the GNOME control center,
you'll want to install this package.

%name-devel helps you create the panels for the control center.

%prep
%setup -n %name-%version%beta %{?_enable_snapshot:-a10
mv libgxdp-%gxdp_ver subprojects/libgxdp}

# define TZ_DATA_FILE "/usr/share/zoneinfo/zone.tab"
#sed -i 's|zone\.tab|zone1970.tab|' panels/system/datetime/tz.h
sed -i 's|\(\/usr\/share\/\)zoneinfo\/\(zone.tab\)|\1%name/\2|' panels/system/datetime/tz.h

%build
%meson \
    %{subst_enable_meson_bool snap snap} \
    %{subst_enable_meson_bool malcontent malcontent} \
    %{subst_enable_meson_bool doc documentation}
%nil
%meson_build

%install
%meson_install
sed -e '/Europe\/Simferopol/ s/^#*/#/' %SOURCE1 > %buildroot%_datadir/%name/zone.tab
%find_lang --with-gnome --output=%name.lang %name-%api_ver %name-%api_ver-timezones %_name

%check
%__meson_test

%files
%_bindir/%name
%_libexecdir/%name-search-provider
%_libexecdir/%name-print-renderer
%_libexecdir/%name-global-shortcuts-provider

%files data -f %name.lang
%dir %_datadir/%name
%_datadir/%name/keybindings
%_datadir/%name/pixmaps
%_datadir/%name/zone.tab
%_desktopdir/*.desktop
%_datadir/pixmaps/faces/
%_iconsdir/hicolor/*/*/*
%_iconsdir/gnome-logo-text*.svg
%_datadir/sounds/gnome/default/alerts/*.ogg
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/polkit-1/actions/org.gnome.controlcenter.system.policy
%_datadir/polkit-1/actions/org.gnome.controlcenter.user-accounts.policy
%_datadir/polkit-1/rules.d/gnome-control-center.rules
%_datadir/polkit-1/actions/org.gnome.controlcenter.remote-login-helper.policy
%_datadir/polkit-1/actions/org.gnome.controlcenter.remote-session-helper.policy
%_datadir/dbus-1/services/%xdg_name.SearchProvider.service
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/interfaces/org.gnome.GlobalShortcutsRebind.xml
%_datadir/dbus-1/services/org.gnome.Settings.GlobalShortcutsProvider.service
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%{?_enable_doc:%_man1dir/%name.1.*}
%_datadir/bash-completion/completions/gnome-control-center
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc NEWS README*

%files devel
%_datadir/pkgconfig/gnome-keybindings.pc
%_datadir/gettext/its/gnome-keybindings.its
%_datadir/gettext/its/gnome-keybindings.loc
%_datadir/gettext/its/sounds.its
%_datadir/gettext/its/sounds.loc


%changelog
