%def_disable snapshot

%define xdg_name org.gnome.Characters
%define ver_major 49
%define beta %nil
%define _libexecdir %_prefix/libexec
%def_without included_libunistring
%def_disable check

Name: gnome-characters
Version: %ver_major.1
Release: alt1%beta

Summary: Character map application for GNOME
Group: Text tools
License: BSD-3-Clause
Url: https://apps.gnome.org/Characters

Vcs: https://gitlab.gnome.org/GNOME/gnome-characters.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%set_typelibdir %_libdir/%xdg_name/girepository-1.0

%define gjs_ver 1.50.0
%define unistring_ver 0.9.5
%define adwaita_ver 1.6

Requires: libgjs >= %gjs_ver
# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(Adw) = 1
Requires: typelib(Gc)
Requires: typelib(GdkPixbuf)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GnomeDesktop) = 4.0
Requires: typelib(GObject)
Requires: typelib(Graphene)
Requires: typelib(Gsk)
Requires: typelib(Gtk) = 4.0
Requires: typelib(IBus)
Requires: typelib(Pango)
Requires: typelib(PangoCairo)

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson
BuildRequires: libgtk4-devel libgjs-devel >= %gjs_ver libdbus-devel
BuildRequires: gobject-introspection-devel libgtk4-gir-devel
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
%{?_without_included_libunistring:BuildRequires: libunistring-devel >= %unistring_ver}
%{?_enable_check:BuildRequires: xvfb-run desktop-file-utils /usr/bin/appstreamcli}
BuildRequires: gperf

%description
Characters is a simple utility application to find and insert unusual
characters.

%prep
%setup -n %name-%version%beta

%build
%meson -Dbuildtype=release
%meson_build

%install
%meson_install
%find_lang %xdg_name

%check
xvfb-run %__meson_test

%files -f %xdg_name.lang
%_bindir/%name
%_libdir/%xdg_name/
%_datadir/%xdg_name/
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_iconsdir/*/*/*/*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc NEWS COPYING README*

%changelog
