%define _unpackaged_files_terminate_build 1

Name: gnofract4d
Version: 4.3
Release: alt2

Summary: Gnofract 4D is a Gnome-based program to draw fractals

License: GPLv2
Group: Sciences/Mathematics
Url: https://github.com/fract4d/gnofract4d

# Source-git: https://github.com/edyoung/gnofract4d.git
Source: %name-%version.tar

# This *really* requires gcc at runtime!
Requires: gcc

%add_python3_req_skip frm_docbook

BuildRequires(pre): rpm-build-python3

BuildRequires: gcc-c++ libGConf-devel libjpeg-devel libpng-devel
BuildRequires: python3-devel

AutoProv: no

%description
Gnofract 4D is a Gnome-based program to draw fractals. What sets it apart from
other fractal programs (and makes it "4D") is the way that it treats the
Mandelbrot and Julia sets as different views of the same four-dimensional
fractal object. This allows you to generate images which are a cross between
the two sets and explore their inter-relationships.

%prep
%setup

%build
%python3_build_debug

%install
%python3_install

# drop all tests
rm -rf %buildroot%python3_sitelibdir/fract*/test*

rm -rf %buildroot/usr/share/doc/gnofract4d

%find_lang %name --with-gnome

%files -f %name.lang
%doc README.md
%_bindir/%name
%python3_sitelibdir/fract4d/
%python3_sitelibdir/fract4d_compiler/
%python3_sitelibdir/fract4dgui/
%python3_sitelibdir/*.egg-info
%_datadir/%name/
%_datadir/mime/packages/*
%_pixmapsdir/*
%_iconsdir/hicolor/*/apps/*.png
%_desktopdir/*

%changelog
