# Note: use chromium-gn-pkgver.sh to get latest version
%define major 1967
%define commit 80a40b07

Name: gn
Version: 0.%major.%commit
Release: alt1

Summary: A meta-build system that generates NinjaBuild files

License: BSD
Group: Development/C++
Url: https://gn.googlesource.com/gn/

#Source-url: https://gn.googlesource.com/gn/+archive/refs/heads/main.tar.gz
# Source-url: https://gn.googlesource.com/gn/+archive/%{commit}.tar.gz
Source: %name-%version.tar

BuildRequires: clang libstdc++-devel ninja-build
BuildRequires: rpm-build-python3
# for tests
BuildRequires: /proc

%description
GN is a meta-build system that generates NinjaBuild files so that you can build Chromium with Ninja.

GN is a GYP replacement
GN files are more readable and more maintainable than GYP files.
GN is 20x faster than GYP.

%prep
%setup
mkdir out
cat <<EOF >out/last_commit_position.h
// Generated by gn.spec
#ifndef OUT_LAST_COMMIT_POSITION_H_
#define OUT_LAST_COMMIT_POSITION_H_

#define LAST_COMMIT_POSITION_NUM %major
#define LAST_COMMIT_POSITION "%major (%commit)"

#endif  // OUT_LAST_COMMIT_POSITION_H_
EOF

%build
./build/gen.py --no-strip --no-last-commit-position --no-static-libstdc++
ninja -C out

%check
./out/gn_unittests

%install
install -m755 -D out/gn %buildroot%_bindir/gn

%files
%doc README.md LICENSE AUTHORS
%_bindir/%name

%changelog
