%define installdir %webserver_webappsdir/%name

Name: glpi
Version: 11.0.1
Release: alt1

Summary: IT and asset management software
License: GPLv3
Group: Networking/Other

URL: http://www.glpi-project.org
Packager: Pavel Zilke <zidex at altlinux dot org>
BuildArch: noarch

Source0: https://github.com/glpi-project/glpi/releases/download/%version/%name-%version.tgz
Source1: apache2.conf
Source2: README.ALT
Source3: UPGRADE.ALT
#Patch: patch0.patch

Requires: webserver-common php-engine curl lynx
BuildRequires(pre): rpm-macros-webserver-common

%description
GLPI is the Information Resource-Manager with an additional Administration-
Interface.
You can use it to build up a database with an inventory for your company
(computer, software, printers...).
It has enhanced functions to make the daily life for the administrators easier,
like a job-tracking-system with mail-notification and methods to build a
database with basic information about your network-topology.

%package apache2
Summary: Apache 2.x web-server configuration for %name
Group: Networking/Other
Requires: %name = %version-%release, apache2
%description apache2
Apache 2.x web-server configuration for %name

%package php8.2
Summary: PHP8.2 dependencies for %name
Group: Networking/Other
Requires: %name = %version-%release
Requires: php8.2
Requires: php8.2-curl, php8.2-fileinfo, php8.2-gd2, php8.2-json, php8.2-mbstring, php8.2-mysqlnd-mysqli, php8.2-session, php8.2-zlib, php8.2-intl
Requires: php8.2-bz2, php8.2-exif, php8.2-ldap, php8.2-opcache, php8.2-openssl, php8.2-sodium, php8.2-xmlreader, php8.2-zip

%description php8.2
php8.3 dependencies for %name

%package php8.3
Summary: PHP8.3 dependencies for %name
Group: Networking/Other
Requires: %name = %version-%release
Requires: php8.3
Requires: php8.3-curl, php8.3-fileinfo, php8.3-gd2, php8.3-json, php8.3-mbstring, php8.3-mysqlnd-mysqli, php8.3-session, php8.3-zlib, php8.3-intl
Requires: php8.3-bz2, php8.3-exif, php8.3-ldap, php8.3-opcache, php8.3-openssl, php8.3-sodium, php8.3-xmlreader, php8.3-zip

%description php8.3
php8.3 dependencies for %name

%package php8.4
Summary: PHP8.4 dependencies for %name
Group: Networking/Other
Requires: %name = %version-%release
Requires: php8.4
Requires: php8.4-curl, php8.4-fileinfo, php8.4-gd2, php8.4-json, php8.4-mbstring, php8.4-mysqlnd-mysqli, php8.4-session, php8.4-zlib, php8.4-intl
Requires: php8.4-bz2, php8.4-exif, php8.4-ldap, php8.4-opcache, php8.4-openssl, php8.4-sodium, php8.4-xmlreader, php8.4-zip

%description php8.4
php8.4 dependencies for %name

%prep
%setup

%build

%install
# install apache config
install -pD -m0644 %_sourcedir/apache2.conf %buildroot%_sysconfdir/httpd2/conf/sites-available/%name.conf

# install glpi
mkdir -p %buildroot%installdir
cp -rp . %buildroot%installdir

#install README.ALT and UPGRADE.ALT
install -pD -m0644 %_sourcedir/README.ALT README.ALT
install -pD -m0644 %_sourcedir/UPGRADE.ALT UPGRADE.ALT

# remove .htaccess files - we're use apache config instead
find %buildroot%installdir -name .htaccess -delete

# remove files
find $RPM_BUILD_ROOT \( -name 'Thumbs.db' -o -name 'Thumbs.db.gz' \) -print -delete
find %buildroot%installdir -name *.py -delete
find %buildroot%installdir -name remove.txt -delete
rm -rf %buildroot%installdir/vendor/sabre/dav/bin

%post
echo "If you upgrade from previous version (less than 9.5) then read /usr/share/doc/%name-%version/UPGRADE.ALT"

%post apache2
if [ "$1" = "1" ]; then
  a2enmod rewrite
  a2ensite %name
  %_initdir/httpd2 condreload
fi
if [ "$1" = "2" ]; then
  a2enmod rewrite
  %_initdir/httpd2 condreload
fi

%preun apache2
if [ "$1" = "0" ]; then
  a2dissite %name ||:
fi

%postun apache2
if [ "$1" = "0" ]; then
  %_initdir/httpd2 condreload
fi

%files
%dir %installdir
%dir %attr(2770,root,%webserver_group) %installdir/config
%dir %attr(2770,root,%webserver_group) %installdir/files
%dir %attr(2770,root,%webserver_group) %installdir/files/_cache
%dir %attr(2770,root,%webserver_group) %installdir/files/_cron
%dir %attr(2770,root,%webserver_group) %installdir/files/_graphs
%dir %attr(2770,root,%webserver_group) %installdir/files/_inventories
%dir %attr(2770,root,%webserver_group) %installdir/files/_locales
%dir %attr(2770,root,%webserver_group) %installdir/files/_lock
%dir %attr(2770,root,%webserver_group) %installdir/files/_log
%dir %attr(2770,root,%webserver_group) %installdir/files/_pictures
%dir %attr(2770,root,%webserver_group) %installdir/files/_plugins
%dir %attr(2770,root,%webserver_group) %installdir/files/_rss
%dir %attr(2770,root,%webserver_group) %installdir/files/_sessions
%dir %attr(2770,root,%webserver_group) %installdir/files/_tmp
%dir %attr(2770,root,%webserver_group) %installdir/files/_uploads
%dir %attr(2770,root,%webserver_group) %installdir/marketplace
%installdir/ajax
%installdir/bin
%installdir/css
%installdir/dependency_injection
%installdir/front
%installdir/inc
%installdir/install
%installdir/lib
%installdir/locales
%installdir/plugins
%installdir/public
%installdir/resources
%installdir/routes
%installdir/src
%installdir/templates
%installdir/vendor
%installdir/version
%installdir/LICENSE
%installdir/index.html
%doc CHANGELOG.md
%doc CONTRIBUTING.md
%doc README.md
%doc SUPPORT.md
%doc SECURITY.md
%doc apirest.md
%doc README.ALT
%doc UPGRADE.ALT

%files apache2
%config(noreplace) %attr(0644,root,root) %_sysconfdir/httpd2/conf/sites-available/%name.conf

%files php8.2

%files php8.3

%files php8.4

%changelog
