Name: glm
Version: 0.9.9.8
Release: alt1
License: MIT
Summary: GLM is a header only C++ mathematics library for graphics software based on the GLSL specification
Group: Development/C++
Url: http://glm.g-truc.net/
BuildRequires: gcc-c++ cmake ctest

Source: %version.tar.gz
Patch0: glm-0.9.9.8-install.patch
Patch1: glm-0.9.9.8-noarch.patch

%package -n lib%name-devel
Summary: GLM is a header only C++ mathematics library for graphics software based on the GLSL specification
Group: Development/C++
BuildArch: noarch

%package -n lib%name-devel-doc
Summary: Documentation for OpenGL Mathematics (GLM) library
Group: Development/Documentation
BuildArch: noarch
Requires: lib%name-devel = %version-%release

%description
C++ library for OpenGL GLSL type-based mathematics OpenGL Mathematics
(GLM) is a header only C++ mathematics library for graphics software
based on the OpenGL Shading Language (GLSL) specification.

GLM provides classes and functions designed and implemented with the
same naming conventions and functionalities as GLSL, so that when a
programmer knows GLSL, he knows GLM as well, which makes it easy to use.

This project isn't limited to GLSL features. An extension system, based
on the GLSL extension conventions, provides extended capabilities:
matrix transformations, quaternions, half-based types, random nums, etc.

%description -n lib%name-devel
C++ library for OpenGL GLSL type-based mathematics OpenGL Mathematics
(GLM) is a header only C++ mathematics library for graphics software
based on the OpenGL Shading Language (GLSL) specification.

GLM provides classes and functions designed and implemented with the
same naming conventions and functionalities as GLSL, so that when a
programmer knows GLSL, he knows GLM as well, which makes it easy to use.

This project isn't limited to GLSL features. An extension system, based
on the GLSL extension conventions, provides extended capabilities:
matrix transformations, quaternions, half-based types, random nums, etc.

Header files for GLM library.

%description -n lib%name-devel-doc
Documentation for the OpenGL Mathematics (GLM) library.
OpenGL Mathematics (GLM) is a header only C++ mathematics library for
graphics software based on the OpenGL Shading Language (GLSL) specs.

This package contains the GLM in HTML and PDF formats.

%prep
%setup

# A couple of files had CRLF line-ends in them.
# Check with rpmlint after updating the package that we are not
# forgetting to convert line endings in some files.
#
# This release of glm seems to have shipped with no CRLF file
# endings at all, so these are commented out.
sed -i 's/\r//' readme.md
sed -i 's/\r//' CMakeLists.txt
sed -i 's/\r//' doc/api/doxygen.css
sed -i 's/\r//' doc/api/dynsections.js
sed -i 's/\r//' doc/api/jquery.js
sed -i 's/\r//' doc/api/tabs.css

# These are just for being able to apply the patch that
# was exported from git.
sed -i 's/\r//' glm/detail/setup.hpp
sed -i 's/\r//' glm/simd/platform.h
sed -i 's/\r//' test/core/core_setup_message.cpp

%patch0 -p1
%patch1 -p1

%build
%add_optflags -fno-strict-aliasing
%cmake -DGLM_TEST_ENABLE=True -DGLM_TEST_ENABLE_CXX_11=True -DCMAKE_VERBOSE_MAKEFILE=True
%cmake_build

%install
%cmake_install

find %buildroot -name '*.la' -exec rm -f {} ';'
find %buildroot -name CMakeLists.txt -exec rm -f {} ';'

# The cmake config files seem architecture independent and since
# also glm-devel is otherwise noarch, it is desired to ship the
# cmake configuration files under /usr/share.
mkdir -pv %buildroot%_datadir
mv %buildroot%_libdir/cmake %buildroot%_datadir/cmake
#they removed pkgconfig in 0.9.9.8
#mv %buildroot%_pkgconfigdir %buildroot%_datadir/pkgconfig
rmdir %buildroot%_libdir

%check
#cmake_build --target test

# Some tests are disabled due to failing tests (to be reported)
# - test-core_func_common fails on aarch64
# - test-gtc_packing      fails on s390x
ctest --output-on-failure -E '(test-core_func_common|test-gtc_packing)'

%files -n lib%name-devel
%_includedir/%name/
%_datadir/cmake/*
#they removed pkgconfig in 0.9.9.8
#%_datadir/pkgconfig/*
%doc copying.txt readme.md

%files -n lib%name-devel-doc
%doc doc/manual.pdf
%doc doc/api/

%changelog
