# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed,lfs=relaxed

Name: gitui
Version: 0.27.0
Release: alt2
Summary: Blazing fast terminal-ui for git written in rust
License: MIT
Group: Development/Other
Url: https://github.com/extrawurst/gitui

Source: %name-%version.tar
BuildRequires: cmake
BuildRequires: openssl-devel
BuildRequires: rust-cargo
%description
%summary.

%prep
%setup
mkdir -p .cargo
# Overwriting due to 'linker' settings.
cat > .cargo/config <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"

[term]
verbose = true
quiet = false

[build]
rustflags = ["-Copt-level=3", "-Cdebuginfo=1", "--cfg=rustix_use_libc"]

[profile.release]
strip = false

# Incorrect linker specs causing failure on aarch64/armh:
#   error: linker 'aarch64-linux-gnu-gcc' not found
[target.'cfg(all())']
linker = "gcc"
EOF
# Use openssl-devel.
sed -i '/^default =/s/"vendor-openssl"//' Cargo.toml
# There should not be non-source precompiled files.
find vendor \( -name '*.a' -o -name '*.lib' -o -name '*.dll' -o -name '*.obj' \) | grep . && exit 1
mkdir -p $HOME/bin
echo -e '#!/bin/sh\ntest $1 = rev-parse && echo %release' > $HOME/bin/git
chmod a+rx $HOME/bin/git

%build
export RUST_BACKTRACE=full
export GITUI_RELEASE=1
cargo build %_smp_mflags --offline --release
cargo tree --no-dedupe --target all --prefix none --format '{l}' | sort -u > LICENSE.dependencies

%install
install -Dp target/release/%name -t %buildroot%_bindir

%check
%buildroot%_bindir/gitui --version | grep -Px '%name \Q%version\E \S+ \(%release\)'
# This recompiles.
cargo test  %_smp_mflags --release

%files
%define _customdocdir %_docdir/%name
%doc CHANGELOG.md FAQ.md KEY_CONFIG.md LICENSE* README.md THEMES.md
%_bindir/gitui

%changelog
