# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed,lfs=relaxed

# Note that upstream has disabled CI tests for git>=2.46
# See: https://github.com/arxanas/git-branchless/issues/1416
%def_disable check

Name: git-branchless
Version: 0.10.0
Release: alt3
Summary: High-velocity, monorepo-scale workflow for Git
License: MIT or Apache-2.0
Group: Development/Tools
Url: https://github.com/arxanas/git-branchless

Source: %name-%version.tar
Patch1: git-branchless-0.10.0-alt-nix-loongarch64.patch
Patch2: git-branchless-fix-esl01-indexedlog-for-rust-1_89.patch

BuildRequires: git
BuildRequires: pkgconfig(libgit2)
BuildRequires: pkgconfig(sqlite3)
BuildRequires: pkgconfig(zlib)
BuildRequires: rust-cargo

%description
git-branchless is a suite of tools which enhances Git in several ways.

%prep
%setup
mkdir -p .cargo
cat >> .cargo/config.toml <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"

[term]
verbose = true
quiet = false

[build]
rustflags = ["-Copt-level=3", "-Cdebuginfo=1"]

[profile.release]
strip = false
EOF
sed -i '/rusqlite/s/"bundled",\?//' Cargo.toml

%autopatch -p1
sed -i -e 's/"files":{[^}]*}/"files":{}/' \
     ./vendor/nix/.cargo-checksum.json ./vendor/esl01-indexedlog/.cargo-checksum.json

%build
cargo build %_smp_mflags --offline --release --all-features

%install
install -Dp target/release/%name -t %buildroot%_bindir
target/release/%name install-man-pages %buildroot%_mandir

%check
%buildroot%_bindir/git-branchless --version |& grep -Fx '%name-opts %version'
ldd %buildroot%_bindir/git-branchless | grep -Fw libsqlite3.so
ldd %buildroot%_bindir/git-branchless | grep -Fw libz.so
ldd %buildroot%_bindir/git-branchless
# Rebuilds because cargo.
export TEST_GIT=$(which git) TEST_GIT_EXEC_PATH=$(git --exec-path)
cargo test --release -- \
	      --skip=test_next_ambiguous_interactive \
	      --skip=test_switch_abort \
	      --skip=test_switch_auto_switch_interactive \
	      --skip=test_switch_auto_switch_interactive_disabled \
	      --skip=test_switch_pty \
	      --skip=test_switch_pty_branch \
	      --skip=test_switch_pty_initial_query

%files
%define _customdocdir %_docdir/%name
%doc CHANGELOG.md LICENSE-APACHE LICENSE-MIT README.md
%doc wiki
%_bindir/git-branchless
%_man1dir/git-branchless*.1*

%changelog
