%define _unpackaged_files_terminate_build 1
Name: giblib
Version: 1.2.4
Release: alt1

%define major   1
%if "%{major}" == "1"
%define libname lib%{name}
%else
%define libname lib%{name}%{major}
%endif
%define develname lib%{name}-devel

Summary: Simple library and a wrapper for imlib2.
License: BSD
Group: System/Libraries
Url: http://linuxbrit.co.uk/%name/
Source: %name-%version.tar.gz
Patch: giblib-alt-configure-use_pkgconfig.patch

BuildRequires: freetype2-devel gcc-c++ hostinfo imlib2-devel libstdc++-devel zlib-devel

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}


%description
giblib is a simple library which wraps imlib2. It provides a wrapper to
imlib2's context API, avoiding all the context_get/set calls, adds fontstyles
to the truetype renderer and supplies a generic doubly-linked list and some
string functions.

%package -n %libname
Summary: Enlightened backgrounds manipulating library
Group: System/Libraries

%description -n %libname
giblib is a simple library which wraps imlib2. It provides a wrapper to
imlib2's context API, avoiding all the context_get/set calls, adds fontstyles
to the truetype renderer and supplies a generic doubly-linked list and some
string functions.

This package contains shared giblib library.

%package -n %develname
Summary: giblib headers and development libraries
Group: Development/C
Requires: %libname = %EVR

%description -n lib%name-devel
This package contains giblib headers and development libraries

%package -n lib%name-devel-static
Summary: giblib static libraries.
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains giblib static libraries.

%prep
%setup
%patch -p2
%autoreconf

%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
%configure %{subst_enable static}

%build
%make_build

%install
%makeinstall

rm -rf %buildroot/usr/doc

%files -n %libname
%doc AUTHORS ChangeLog README
%_libdir/*.so.%{major}
%_libdir/*.so.%{major}.*

%files -n %develname
%_bindir/*-config
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
