%def_enable snapshot
%define _unpackaged_files_terminate_build 1

%define ver_major 48
%define beta %nil
%define api_ver_major 4
%define api_ver %api_ver_major.0
%define namespace Hex
%define libname gtkhex-%api_ver_major
%define xdg_name org.gnome.GHex

%def_enable introspection
%def_disable gtk_doc
%def_disable check

Name: ghex
Version: %ver_major.2
Release: alt1%beta

Summary: Binary editor for GNOME
Group: Development/Tools
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Apps/Ghex

Vcs: https://gitlab.gnome.org/GNOME/ghex.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major%beta/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.68
%define gtk4_ver 4.4.0
%define adw_ver 1.2

Requires: libgtkhex = %EVR
Requires: dconf yelp

BuildRequires(pre): rpm-macros-meson %{?_enable_introspection:rpm-build-gir}
BuildRequires: meson glib2-devel >= %glib_ver libgtk4-devel >= %gtk4_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: yelp-tools vala-tools
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk4-gir-devel}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_check:BuildRequires: desktop-file-utils /usr/bin/appstreamcli}

%description
GHex is a hex editor for the GNOME desktop.

GHex can load raw data from binary files and display them for editing in
the traditional hex editor view. The display is split in two columns,
with hexadecimal values in one column and the ASCII representation in
the other. A useful tool for working with raw data.

%package -n libgtkhex
Summary: GtkHex shared library
Group: System/Libraries

%description -n libgtkhex
This package provides shared librarys needed for GtkGHex to work.

%package -n libgtkhex-devel
Summary: Development files for GtkHex
Group: Development/C
Requires: libgtkhex = %EVR

%description -n libgtkhex-devel
This package contains libraries and header files for
developing applications that use GtkGHex library.

%package -n libgtkhex-gir
Summary: GObject introspection data for the GtkGHex
Group: System/Libraries
Requires: libgtkhex = %EVR

%description -n libgtkhex-gir
GObject introspection data for the GtkGHex library.

%package -n libgtkhex-gir-devel
Summary: GObject introspection devel data for the GtkGHex
Group: System/Libraries
BuildArch: noarch
Requires: libgtkhex-gir = %EVR
Requires: libgtkhex-devel = %EVR

%description -n libgtkhex-gir-devel
GObject introspection devel data for the GtkGHex library.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_feature introspection introspection} \
    %{subst_enable_meson_bool gtk_doc gtk_doc}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name %name-%api_ver

%check
%meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/*/apps/*
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc NEWS README*

%files -n libgtkhex
%dir %_libdir/gtkhex-%api_ver
%_libdir/gtkhex-%api_ver/libhex-buffer-mmap.so
%_libdir/gtkhex-%api_ver/libhex-buffer-direct.so
%_libdir/lib%libname.so.*

%files -n libgtkhex-devel
%_includedir/%libname/
%_libdir/lib%libname.so
%_pkgconfigdir/%libname.pc
%{?_enable_gtk_doc:%_datadir/doc/gtkhex-%api_ver/}

%if_enabled introspection
%files -n libgtkhex-gir
%_typelibdir/%namespace-%api_ver_major.typelib

%files -n libgtkhex-gir-devel
%_girdir/%namespace-%api_ver_major.gir
%endif

%changelog
