%define _unpackaged_files_terminate_build 1

%if %{expand:%%{!?_without_check:%%{!?_disable_check:1}}0}
%define tests YES
%else
%define tests NO
%endif

Name: gerbera
Version: 2.6.1
Release: alt1

Summary: UPnP Media Server
Group: System/Servers
License: GPLv2 and MIT
Url: https://gerbera.io
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: %name-data = %EVR

BuildRequires(pre): rpm-macros-cmake rpm-macros-ninja-build
BuildRequires: ninja-build
BuildRequires: gcc-c++
BuildRequires: libupnp-devel >= 1.14.12
BuildRequires: libspdlog-devel >= 1.8.5
BuildRequires: libuuid-devel
BuildRequires: libsqlite3-devel >= 3.35.5
BuildRequires: libduktape-devel >= 2.5.0
BuildRequires: libcurl-devel
BuildRequires: libtag-devel >= 1.12
BuildRequires: libmagic-devel
BuildRequires: libwavpack-devel >= 5.1.0
BuildRequires: libpugixml-devel >= 1.10
BuildRequires: libexif-devel
BuildRequires: libexiv2-devel >= 0.26
BuildRequires: libffmpegthumbnailer-devel >= 2.2.0
BuildRequires: libmatroska-devel >= 1.6.3
BuildRequires: libmysqlclient21-devel
BuildRequires: jsoncpp-devel
BuildRequires: libicu-devel

# for check
%{?!_without_check:%{?!_disable_check:BuildRequires: ctest libgtest-devel}}

%description
Gerbera is a UPnP media server which allows you to stream your digital
media through your home network and consume it on a variety of UPnP
compatible devices.

%package data
Summary: Data files for Gerbera
BuildArch: noarch
Group: System/Servers

%description data
Data files for the Gerbera media server.

%prep
%setup
%patch -p1
%ifarch %e2k
sed -i 's/upnpMap {}/upnpMap = {}/' src/content/import_service.h
%endif

%build
%cmake \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -GNinja \
    -DWITH_TESTS=%tests \
    -DWITH_JS=YES \
    -DWITH_MYSQL=YES \
    -DWITH_CURL=YES \
    -DWITH_TAGLIB=YES \
    -DWITH_MAGIC=YES \
    -DWITH_AVCODEC=YES \
    -DWITH_WAVPACK=YES \
    -DWITH_EXIF=YES \
    -DWITH_EXIV2=YES \
    -DWITH_FFMPEGTHUMBNAILER=YES \
    -DWITH_INOTIFY=YES \
    -DWITH_SYSTEMD=YES \
    -DUPNP_HAS_REUSEADDR=YES

%cmake_build

%install
mkdir -p %buildroot{%_sysconfdir,%_localstatedir,%_logdir}/%name
%cmake_install

%buildroot%_bindir/%name --create-config --home %_localstatedir/%name > %buildroot%_sysconfdir/%name/config.xml

mkdir -p %buildroot%_logrotatedir
cat > %buildroot%_logrotatedir/%name << 'EOF'
/var/log/gerbera/gerbera {
      monthly
      missingok
      create 0644 gerbera gerbera
      su gerbera gerbera
      notifempty
      compress
}
EOF

touch %buildroot%_localstatedir/%name/{%name.db,%name.html}

%check
%ctest

%pre
groupadd -r -f %name >/dev/null 2>&1 ||:
useradd -r -n -g %name -d %_localstatedir/%name -s /dev/null \
    -c 'Gerbera UPnP Media Server' %name >/dev/null 2>&1 ||:

%post
%post_service %name

%preun
%preun_service  %name

%files
%doc LICENSE.md AUTHORS CONTRIBUTING.md ChangeLog.md
%doc doc/*.rst
%dir %attr(750,root,%name) %_sysconfdir/%name
%config(noreplace) %attr(750,root,%name) %_sysconfdir/%name/config.xml
%attr(750,%name,adm) %_logdir/%name
%config(noreplace) %_logrotatedir/%name
%_bindir/%name
%_man1dir/*
%_unitdir/%name.service
%attr(3770,root,%name) %dir %_localstatedir/%name
%ghost %attr(775,%name,%name) %_localstatedir/%name/%name.db
%ghost %attr(775,%name,%name) %_localstatedir/%name/%name.html

%files data
%_datadir/%name
%_datadir/bash-completion/completions/%name

%changelog
