%def_disable snapshot

%define _name geoclue
%define xdg_name org.freedesktop.GeoClue2
%define ver_major 2.8
%define api_ver 2.0
%define _libexecdir %_prefix/libexec

%def_enable wifi
# default-wifi-url=https://api.beacondb.net/v1/geolocate
%def_enable 3g
%def_enable nmea
%def_enable gtk_doc
%def_enable introspection
%def_enable vala
%def_enable check

Name: %{_name}2
Version: %ver_major.0
Release: alt1

Summary: The Geoinformation Service
Group: System/Libraries
License: GPL-2.0-or-later and LGPL-2.1-or-later
Url: https://geoclue.freedesktop.org/

Vcs: https://gitlab.freedesktop.org/geoclue/geoclue.git

%if_disabled snapshot
Source: https://gitlab.freedesktop.org/%_name/%_name/-/archive/%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

%define glib_ver 2.74
%define mm_ver 1.12
%define soup3_ver 3.0

BuildRequires(pre): rpm-macros-meson rpm-build-xdg
BuildRequires: meson yelp-tools gtk-doc libgio-devel >= %glib_ver
BuildRequires: libjson-glib-devel libsoup3.0-devel >= %soup3_ver
BuildRequires: libdbus-devel libnotify-devel systemd-devel
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_nmea:BuildRequires: libavahi-glib-devel}
%{?_enable_3g:BuildRequires: libmm-glib-devel >= %mm_ver}
%{?_enable_check:BuildRequires: /proc dbus-tools-gui}

%description
GeoClue is a D-Bus geoinformation service. The goal of the Geoclue
project is to make creating location-aware applications as simple as
possible.

%package devel
Summary: Development package for GeoClue
Group: Development/C
Requires: %name = %EVR

%description devel
Files for development with GeoClue.

%package -n lib%name
Summary: GeoClue Convenience Library
Group: System/Libraries

%description -n lib%name
This package provides convenience shared library that makes interacting with
Geoclue very easy.

%package -n lib%name-devel
Summary: Header files for GeoClue library
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package provides development files for GeoClue library.

%package -n lib%name-gir
Summary: GObject introspection data for the GeoClue library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the GeoClue library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GeoClue library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the GeoClue library.

%package devel-doc
Summary: Developer documentation for GeoClue
Group: Development/Documentation
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
Developer documentation for GeoClue.

%package -n lib%name-devel-doc
Summary: Developer documentation for GeoClue library
Group: Development/Documentation
Conflicts: lib%name < %version
BuildArch: noarch

%description -n lib%name-devel-doc
Developer documentation for GeoClue library.

%package demo
Summary: Demo programs for GeoClue
Group: Development/C
Requires: %name = %EVR
Requires: lib%name = %EVR

%description demo
This package contains demo programs for GeoClue.

%prep
%setup -n %_name-%version
rm -f demo/*.desktop.in

%build
%meson \
    -Ddbus-srv-user=%_name \
    %{subst_enable_meson_bool nmea nmea-source} \
    %{subst_enable_meson_bool wifi wifi-source} \
    %{subst_enable_meson_bool 3g 3g-source} \
    %{subst_enable_meson_bool gtk_doc gtk-doc} \
    %{subst_enable_meson_bool introspection introspection} \
    -Ddemo-agent=true
%nil
%meson_build

%install
%meson_install
mkdir -p %buildroot%_localstatedir/%_name
mkdir -p %buildroot%_sysconfdir/%_name/conf.d

echo 'd %_localstatedir/%_name 0755 %_name %_name' | \
install -D -m644 /dev/stdin %buildroot%_tmpfilesdir/%_name.conf

%check
%__meson_test

%pre
%_sbindir/groupadd -r -f %_name
%_sbindir/useradd -r -g %_name -d %_localstatedir/%_name -s /dev/null \
    -c 'User for GeoClue service' %_name >/dev/null 2>&1 ||:

%files
%_libexecdir/%_name
%dir %_sysconfdir/%_name/conf.d
#%_sysconfdir/%_name/conf.d/20-beacondb.conf
%_datadir/dbus-1/system.d/%xdg_name.conf
%_datadir/dbus-1/system.d/%xdg_name.Agent.conf
%_datadir/dbus-1/interfaces/%xdg_name.Agent.xml
%_datadir/dbus-1/interfaces/%xdg_name.Client.xml
%_datadir/dbus-1/interfaces/%xdg_name.Location.xml
%_datadir/dbus-1/interfaces/%xdg_name.Manager.xml
%_datadir/dbus-1/interfaces/%xdg_name.xml
%_datadir/dbus-1/system-services/%xdg_name.service
%_datadir/polkit-1/rules.d/%xdg_name.rules
%systemd_unitdir/%_name.service
%config %_sysconfdir/%_name/%_name.conf
%attr(755,%_name,%_name) %dir %_localstatedir/%_name
%_tmpfilesdir/%_name.conf
%_sysusersdir/%_name-sysusers.conf
%_man5dir/%_name.5*
%doc README* NEWS

%files devel
%_pkgconfigdir/%_name-%api_ver.pc

%files -n lib%name
%_libdir/lib%_name-2.so.*

%files -n lib%name-devel
%_includedir/lib%_name-%api_ver/
%_libdir/lib%_name-2.so
%_pkgconfigdir/lib%_name-%api_ver.pc
%{?_enable_vala:%_vapidir/lib%_name-%api_ver.deps
%_vapidir/lib%_name-%api_ver.vapi}

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Geoclue-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Geoclue-%api_ver.gir
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name/

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/lib%_name/
%endif

%files demo
%_libexecdir/%_name-%api_ver/demos/
%_desktopdir/*.desktop
%_xdgconfigdir/autostart/%_name-demo-agent.desktop

%changelog
