# vim: set ft=spec: -*- rpm-spec -*-

%define        _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%def_enable    devel
%define        gemname ruby-prof

Name:          gem-ruby-prof
Version:       1.7.0
Release:       alt1
Summary:       Fast code profiler for Ruby
License:       BSD-2-Clause
Group:         Development/Ruby
Url:           https://github.com/ruby-prof/ruby-prof
Vcs:           https://github.com/ruby-prof/ruby-prof.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
%if_enabled check
BuildRequires: gem(minitest) >= 0
BuildRequires: gem(rake-compiler) >= 0
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Provides:      gem(ruby-prof) = 1.7.0


%description
ruby-prof is a fast code profiler for MRI Ruby. Its features include:

* Speed - it is a C extension and therefore many times faster than the standard
  Ruby profiler.
* Modes - Ruby prof can measure a number of different parameters, including call
  times, memory usage and object allocations.
* Reports - can generate text and cross-referenced html reports
  - Flat Profiles - similar to the reports generated by the standard Ruby
    profiler
  - Graph profiles - similar to GProf, these show how long a method runs, which
    methods call it and which methods it calls.
  - Call tree profiles - outputs results in the calltree format suitable for the
    KCacheGrind profiling tool.
  - Many more - see reports section of this README.
* Threads - supports profiling multiple threads simultaneously


%package       -n ruby-prof
Version:       1.7.0
Release:       alt1
Summary:       Fast code profiler for Ruby executable(s)
Summary(ru_RU.UTF-8): Исполнямка для самоцвета ruby-prof
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(ruby-prof) = 1.7.0

%description   -n ruby-prof
Fast code profiler for Ruby executable(s).

ruby-prof is a fast code profiler for MRI Ruby. Its features include:

* Speed - it is a C extension and therefore many times faster than the standard
Ruby profiler.
* Modes - Ruby prof can measure a number of different parameters, including call
times, memory usage and object allocations.
* Reports - can generate text and cross-referenced html reports
  - Flat Profiles - similar to the reports generated by the standard Ruby
    profiler
  - Graph profiles - similar to GProf, these show how long a method runs, which
    methods call it and which methods it calls.
  - Call tree profiles - outputs results in the calltree format suitable for the
    KCacheGrind profiling tool.
  - Many more - see reports section of this README.
* Threads - supports profiling multiple threads simultaneously

%description   -n ruby-prof -l ru_RU.UTF-8
Исполнямка для самоцвета ruby-prof.


%if_enabled    doc
%package       -n gem-ruby-prof-doc
Version:       1.7.0
Release:       alt1
Summary:       Fast code profiler for Ruby documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета ruby-prof
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(ruby-prof) = 1.7.0
Obsoletes:     ruby-ruby-prof-doc
Provides:      ruby-ruby-prof-doc

%description   -n gem-ruby-prof-doc
Fast code profiler for Ruby documentation files.

ruby-prof is a fast code profiler for MRI Ruby. Its features include:

* Speed - it is a C extension and therefore many times faster than the standard
  Ruby profiler.
* Modes - Ruby prof can measure a number of different parameters, including call
  times, memory usage and object allocations.
* Reports - can generate text and cross-referenced html reports
  - Flat Profiles - similar to the reports generated by the standard Ruby
    profiler
  - Graph profiles - similar to GProf, these show how long a method runs, which
    methods call it and which methods it calls.
  - Call tree profiles - outputs results in the calltree format suitable for the
    KCacheGrind profiling tool.
  - Many more - see reports section of this README.
* Threads - supports profiling multiple threads simultaneously

%description   -n gem-ruby-prof-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета ruby-prof.
%endif


%if_enabled    devel
%package       -n gem-ruby-prof-devel
Version:       1.7.0
Release:       alt1
Summary:       Fast code profiler for Ruby development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета ruby-prof
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(ruby-prof) = 1.7.0
Requires:      gem(minitest) >= 0
Requires:      gem(rake-compiler) >= 0

%description   -n gem-ruby-prof-devel
Fast code profiler for Ruby development package.

ruby-prof is a fast code profiler for MRI Ruby. Its features include:

* Speed - it is a C extension and therefore many times faster than the standard
  Ruby profiler.
* Modes - Ruby prof can measure a number of different parameters, including call
  times, memory usage and object allocations.
* Reports - can generate text and cross-referenced html reports - Flat Profiles
- similar to the reports generated by the standard Ruby profiler - Graph
  profiles - similar to GProf, these show how long a method runs, which methods
  call it and which methods it calls. - Call tree profiles - outputs results in
  the calltree format suitable for the KCacheGrind profiling tool. - Many more -
  see reports section of this README.
* Threads - supports profiling multiple threads simultaneously

%description   -n gem-ruby-prof-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета ruby-prof.
%endif


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.md
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n ruby-prof
%doc README.md
%_bindir/ruby-prof
%_bindir/ruby-prof-check-trace

%if_enabled    doc
%files         -n gem-ruby-prof-doc
%doc README.md
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-ruby-prof-devel
%doc README.md
%ruby_includedir/*
%endif


%changelog
