%define        _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%def_enable    devel
%define        gemname ruby-ldap

Name:          gem-ruby-ldap
Version:       0.9.21
Release:       alt1
Summary:       Ruby LDAP library
License:       BSD
Group:         Development/Ruby
Url:           https://github.com/bearded/ruby-ldap
Vcs:           https://github.com/bearded/ruby-ldap.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
Patch:         %name-%EVR.patch
BuildRequires(pre): rpm-build-ruby
BuildRequires: libldap-devel
BuildRequires: libssl-devel
BuildRequires: libsasl2-devel

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-ldap < %EVR
Provides:      ruby-ldap = %EVR
Provides:      gem(ruby-ldap) = 0.9.21


%description
Ruby/LDAP is an extension library for Ruby. It provides the interface to some
LDAP libraries (e.g. OpenLDAP, UMich LDAP, Netscape SDK, ActiveDirectory). The
common API for application development is described in RFC1823 and is supported
by Ruby/LDAP.


%if_enabled    doc
%package       -n gem-ruby-ldap-doc
Version:       0.9.21
Release:       alt1
Summary:       Ruby LDAP library documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета ruby-ldap
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(ruby-ldap) = 0.9.21

%description   -n gem-ruby-ldap-doc
Ruby LDAP library documentation files.

Ruby/LDAP is an extension library for Ruby. It provides the interface to some
LDAP libraries (e.g. OpenLDAP, UMich LDAP, Netscape SDK, ActiveDirectory). The
common API for application development is described in RFC1823 and is supported
by Ruby/LDAP.

%description   -n gem-ruby-ldap-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета ruby-ldap.
%endif


%if_enabled    devel
%package       -n gem-ruby-ldap-devel
Version:       0.9.21
Release:       alt1
Summary:       Ruby LDAP library development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета ruby-ldap
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(ruby-ldap) = 0.9.21
Requires:      libldap-devel
Requires:      libssl-devel
Requires:      libsasl2-devel

%description   -n gem-ruby-ldap-devel
Ruby LDAP library development package.

Ruby/LDAP is an extension library for Ruby. It provides the interface to some
LDAP libraries (e.g. OpenLDAP, UMich LDAP, Netscape SDK, ActiveDirectory). The
common API for application development is described in RFC1823 and is supported
by Ruby/LDAP.

%description   -n gem-ruby-ldap-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета ruby-ldap.
%endif


%prep
%setup
%autopatch -p1

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%if_enabled    doc
%files         -n gem-ruby-ldap-doc
%doc README
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-ruby-ldap-devel
%doc README
%endif


%changelog
