%define        _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%def_enable    devel
%define        gemname passenger

Name:          gem-passenger
Version:       6.1.0
Release:       alt1
Summary:       Easy and robust deployment Ruby on Rails applications on Apache and Nginx webservers
Summary(ru_RU.UTF-8): Простой и ясный мост между приложениями на Рельсах и серверами Апач и Нжинкс
License:       MIT
Group:         System/Servers
Url:           https://github.com/phusion/passenger
Vcs:           https://github.com/phusion/passenger.git
Packager:      Baltix Maintaining Team <baltix@packages.altlinux.org>

Source:        %name-%version.tar
Source1:       passenger.load
Source2:       passenger.conf
Source3:       passenger.start
Source4:       locations.ini
Patch:         patch.patch
BuildRequires(pre): rpm-build-ruby
BuildRequires(pre): rpm-macros-apache2
BuildRequires(pre): rpm-build-python3
BuildRequires: %(eval echo %apache2_apr_buildreq)
BuildRequires: apache2-devel >= 2.2.5
BuildRequires: zlib-devel
BuildRequires: libapr1-devel
BuildRequires: libaprutil1-devel
BuildRequires: libssl-devel
BuildRequires: libcurl-devel
BuildRequires: apache2-httpd-worker
BuildRequires: gcc-c++
BuildRequires: gnu-config
%if_enabled check
BuildRequires: gem(drake) >= 0
BuildRequires: gem(gpgme) >= 0
BuildRequires: gem(json) >= 0
BuildRequires: gem(mime-types) >= 3.5.1
BuildRequires: gem(rack) >= 1.6.13
BuildRequires: gem(rackup) >= 1.0.1
BuildRequires: gem(rake) >= 12.3.3
BuildRequires: gem(rspec) >= 3.10.0
BuildRequires: gem(rspec-collection_matchers) >= 0
BuildRequires: gem(webrick) >= 1.8.1
BuildConflicts: gem(mime-types) >= 4
BuildConflicts: gem(rspec) >= 4
BuildConflicts: gem(webrick) >= 1.9
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency mime-types >= 3.5.2,mime-types < 4
%ruby_use_gem_dependency rspec >= 3.10.0,rspec < 4
Requires(pre): apache2 >= %apache2_version-%apache2_release
Requires:      ruby >= 2.5
Requires:      gem(rack) >= 1.6.13
Requires:      gem(rackup) >= 1.0.1
Requires:      gem(rake) >= 12.3.3
Conflicts:     ruby1.8-passenger
Provides:      gem(passenger) = 6.1.0

%ruby_on_build_rake_tasks apache2

%description
Phusion Passenger - a.k.a. mod_rails or mod_rack - makes deployment of Ruby web
applications, such as those built on the revolutionary Ruby on Rails web
framework, a breeze. It follows the usual Ruby on Rails conventions, such as
"Don't-Repeat-Yourself".
* Deployment is only a matter of uploading application files. No Ruby (on
Rails)-specific server configuration required!
* Supports both the industry standard Apache web server and the fast and
lightweight Nginx web server.
* Allows Ruby on Rails applications to use about 33%% less memory, when used in
combination with Ruby Enterprise Edition (optional).
* Zero maintenance. No port management, server process monitoring or stale file
cleanup required. Errors are automatically recovered whenever possible.
* Designed for performance, stability and security. Phusion Passenger should
never crash Apache even in case of crashing Rails applications
* Well-documented, for both system administrators and developers!

%description         -l ru_RU.UTF-8
Phusion Passenger™ известный как mod_rails или mod_rack


%package       -n passenger
Version:       6.1.0
Release:       alt1
Summary:       Easy and robust deployment Ruby on Rails applications on Apache and Nginx webservers executable(s)
Summary(ru_RU.UTF-8): Исполнямка для самоцвета passenger
Group:         Other
BuildArch:     noarch

Requires:      gem(passenger) = 6.1.0

%description   -n passenger
Easy and robust deployment Ruby on Rails applications on Apache and Nginx
webservers executable(s).

Phusion Passenger - a.k.a. mod_rails or mod_rack - makes deployment of Ruby web
applications, such as those built on the revolutionary Ruby on Rails web
framework, a breeze. It follows the usual Ruby on Rails conventions, such as
"Don't-Repeat-Yourself".
* Deployment is only a matter of uploading application files. No Ruby (on
Rails)-specific server configuration required!
* Supports both the industry standard Apache web server and the fast and
lightweight Nginx web server.
* Allows Ruby on Rails applications to use about 33%% less memory, when used in
combination with Ruby Enterprise Edition (optional).
* Zero maintenance. No port management, server process monitoring or stale file
cleanup required. Errors are automatically recovered whenever possible.
* Designed for performance, stability and security. Phusion Passenger should
never crash Apache even in case of crashing Rails applications
* Well-documented, for both system administrators and developers!

%description   -n passenger -l ru_RU.UTF-8
Исполнямка для самоцвета passenger.


%if_enabled    doc
%package       -n gem-passenger-doc
Version:       6.1.0
Release:       alt1
Summary:       Easy and robust deployment Ruby on Rails applications on Apache and Nginx webservers documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета passenger
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(passenger) = 6.1.0

%description   -n gem-passenger-doc
Easy and robust deployment Ruby on Rails applications on Apache and Nginx
webservers documentation files.

Phusion Passenger - a.k.a. mod_rails or mod_rack - makes deployment of Ruby web
applications, such as those built on the revolutionary Ruby on Rails web
framework, a breeze. It follows the usual Ruby on Rails conventions, such as
"Don't-Repeat-Yourself".
* Deployment is only a matter of uploading application files. No Ruby (on
Rails)-specific server configuration required!
* Supports both the industry standard Apache web server and the fast and
lightweight Nginx web server.
* Allows Ruby on Rails applications to use about 33%% less memory, when used in
combination with Ruby Enterprise Edition (optional).
* Zero maintenance. No port management, server process monitoring or stale file
cleanup required. Errors are automatically recovered whenever possible.
* Designed for performance, stability and security. Phusion Passenger should
never crash Apache even in case of crashing Rails applications
* Well-documented, for both system administrators and developers!

%description   -n gem-passenger-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета passenger.
%endif


%if_enabled    devel
%package       -n gem-passenger-devel
Version:       6.1.0
Release:       alt1
Summary:       Easy and robust deployment Ruby on Rails applications on Apache and Nginx webservers development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета passenger
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(passenger) = 6.1.0
Requires:      gem(drake) >= 0
Requires:      gem(gpgme) >= 0

%description   -n gem-passenger-devel
Easy and robust deployment Ruby on Rails applications on Apache and Nginx
webservers development package.

Phusion Passenger - a.k.a. mod_rails or mod_rack - makes deployment of Ruby web
applications, such as those built on the revolutionary Ruby on Rails web
framework, a breeze. It follows the usual Ruby on Rails conventions, such as
"Don't-Repeat-Yourself".
* Deployment is only a matter of uploading application files. No Ruby (on
Rails)-specific server configuration required!
* Supports both the industry standard Apache web server and the fast and
lightweight Nginx web server.
* Allows Ruby on Rails applications to use about 33%% less memory, when used in
combination with Ruby Enterprise Edition (optional).
* Zero maintenance. No port management, server process monitoring or stale file
cleanup required. Errors are automatically recovered whenever possible.
* Designed for performance, stability and security. Phusion Passenger should
never crash Apache even in case of crashing Rails applications
* Well-documented, for both system administrators and developers!

%description   -n gem-passenger-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета passenger.
%endif


%package       -n apache2-mod-passenger
Version:       6.1.0
Release:       alt2
Summary:       Easy and robust deployment Ruby on Rails applications on Apache and Nginx webservers apache module files
Summary(ru_RU.UTF-8): Модуль passenger для вебсервера apache
Group:         System/Servers

Requires:      passenger = 6.1.0
Requires:      apache2-httpd-worker
Provides:      apache2-mod_passenger = 6.1.0
Provides:      mod_passenger = 6.1.0

%description   -n apache2-mod-passenger
Easy and robust deployment Ruby on Rails applications on Apache and Nginx
webservers apache module files.

Phusion Passenger - a.k.a. mod_rails or mod_rack - makes deployment of Ruby web
applications, such as those built on the revolutionary Ruby on Rails web
framework, a breeze. It follows the usual Ruby on Rails conventions, such as
"Don't-Repeat-Yourself".
* Deployment is only a matter of uploading application files. No Ruby
  (on Rails)-specific server configuration required!
* Supports both the industry standard Apache web server and the fast and
  lightweight Nginx web server.
* Allows Ruby on Rails applications to use about 33%% less memory, when used in
  combination with Ruby Enterprise Edition (optional).
* Zero maintenance. No port management, server process monitoring or stale file
  cleanup required. Errors are automatically recovered whenever possible.
* Designed for performance, stability and security. Phusion Passenger should
  never crash Apache even in case of crashing Rails applications
* Well-documented, for both system administrators and developers!

%description   -n apache2-mod-passenger -l ru_RU.UTF-8
Файлы для разработки самоцвета passenger.


%prep
%setup
%autopatch
# Set correct python3 executable in shebang
subst 's|#!.*python$|#!%__python3|' $(grep -Rl '#!.*python$' *)
subst '1i #!%__python3' test/stub/wsgi/passenger_wsgi.py
cp -a -t src/cxx_supportlib/vendor-modified/libev /usr/share/gnu-config/config.{guess,sub}
cp -a -t src/cxx_supportlib/vendor-copy/libuv /usr/share/gnu-config/config.{guess,sub}

%build
%ruby_build

%install
%ruby_install
%ifnarch armh
mkdir -p %buildroot%ruby_gemextdir/
mv -f $(find buildout/ -name passenger_native_support.so) %buildroot%ruby_gemextdir/
%endif

#mod_passenger
%ifnarch armh
install -p -D -m 755 -- buildout/apache2/mod_passenger.so %buildroot%apache2_libexecdir/mod_passenger.so
%endif
install -d -m 755 -- %buildroot%apache2_mods_available
install -d -m 755 -- %buildroot%apache2_mods_start
install -p -m 644 -- %SOURCE1 %buildroot%apache2_mods_available/passenger.load
install -p -m 644 -- %SOURCE2 %buildroot%apache2_mods_available/passenger.conf
install -p -m 644 -- %SOURCE3 %buildroot%apache2_mods_start/100-passenger.conf
install -p -D -m 644 -- %SOURCE4 %buildroot/%ruby_gemlibdir/locations.ini
sed 's,@a_libexecdir@,%apache2_libexecdir,g' \
    -i %buildroot%apache2_mods_available/passenger.load
sed -e 's,@passenger_path@,%ruby_gemlibdir/locations.ini,g' -e 's,@ruby_exec@,%__ruby,g' \
    -i %buildroot%apache2_mods_available/passenger.conf
sed -e 's,@rubylibdir@,%ruby_sitearchdir,g' \
    -e 's,@a_libexecdir@,%apache2_libexecdir,g' \
    -e 's,@bindir@,%_bindir,g' \
    -e 's,@libdir@,%_libdir,g' \
    -e 's,@datadir@,%_datadir,g' \
    -e 's,@name@,%name,g' \
    -i %buildroot%ruby_gemlibdir/locations.ini

%check
%ruby_test

%post          -n apache2-mod-passenger
# Reconfigure Apache2:
%apache2_sbindir/a2chkconfig ||:

if [ -e %apache2_mods_enabled/passenger.load ]; then
    CONF_OK=0
    %apache2_sbindir/apachectl2 configtest && CONF_OK=1 ||:
    if [ "$CONF_OK" = "1" ]; then
	service %apache2_dname condrestart ||:
    else
	echo "Some errors detected in Apache2 configuration!"
	echo "To use mod_passenger check configuration and start %apache2_dname service."
	echo
    fi
else
    echo "Apache2 mod_passenger module had been installed, but does't enabled."
    echo "Check %apache2_mods_start directory for files with 'passenger=no' lines."
    echo
fi

%preun         -n apache2-mod-passenger
if [ "$1" = "0" ] ; then # last uninstall
    [ -e %apache2_mods_enabled/passenger.load ] && %apache2_sbindir/a2dismod passenger 2>&1 >/dev/null ||:
fi

%postun        -n apache2-mod-passenger
# Reconfigure Apache2:
%apache2_sbindir/a2chkconfig ||:
if [ "$1" = "0" ] ; then # last uninstall
    CONF_OK=0
    %apache2_sbindir/apachectl2 configtest && CONF_OK=1 ||:
    if [ "$CONF_OK" = "1" ]; then
	service %apache2_dname condrestart ||:
    else
	echo "Some errors detected in Apache2 configuration!"
	echo "To complete mod_passenger uninstalling check configuration and restart %apache2_dname service."
	echo
    fi
fi

%files
%doc CHANGELOG CONTRIBUTING.md CONTRIBUTORS LICENSE README.md CODE_OF_CONDUCT.md
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n passenger
%doc CHANGELOG CONTRIBUTING.md CONTRIBUTORS LICENSE README.md CODE_OF_CONDUCT.md
%_bindir/passenger
%_bindir/passenger-install-apache2-module
%_bindir/passenger-install-nginx-module
%_bindir/passenger-config
%_bindir/passenger-status
%_bindir/passenger-memory-stats
%_mandir/*

%if_enabled    doc
%files         -n gem-passenger-doc
%doc CHANGELOG CONTRIBUTING.md CONTRIBUTORS LICENSE README.md CODE_OF_CONDUCT.md
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-passenger-devel
%doc CHANGELOG CONTRIBUTING.md CONTRIBUTORS LICENSE README.md CODE_OF_CONDUCT.md
%endif

%files         -n apache2-mod-passenger
%config(noreplace) %apache2_mods_available/passenger.conf
%config            %apache2_mods_available/passenger.load
%config            %apache2_mods_start/100-passenger.conf
%ifnarch armh
%apache2_libexecdir/mod_passenger.so
%endif


%changelog
