%define        pkgname net-ssh-multi
 
Name:          gem-%pkgname
Version:       1.3.0
Release:       alt0.1
Summary:       SSH connection multiplexing: execute commands simultaneously on multiple hosts via SSH
License:       MIT
Group:         Development/Ruby
Url:           https://github.com/net-ssh/net-ssh-multi
Vcs:           https://github.com/net-ssh/net-ssh-multi.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch
 
Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(mocha)
BuildRequires: gem(net-ssh)
 
%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%gemname < %EVR
Provides:      ruby-%gemname = %EVR

%description
Net::SSH::Multi is a library for controlling multiple Net::SSH
connections via a single interface. It exposes an API similar to that of
Net::SSH::Connection::Session and Net::SSH::Connection::Channel, making
it simpler to adapt programs designed for single connections to be used
with multiple connections.

This library is particularly useful for automating repetitive tasks that
must be performed on multiple machines. It executes the commands in
parallel, and allows commands to be executed on subsets of servers
(defined by groups).


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup
 
%build
%ruby_build --use=%gemname --version-replace=%version
 
%install
%ruby_install
 
%check
%ruby_test
 
%files
%doc README*
%ruby_gemspec
%ruby_gemlibdir

%files         doc
%ruby_gemdocdir
 
%changelog
