%define        _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%def_enable    devel
%define        gemname mocha

Name:          gem-mocha
Version:       2.7.1
Release:       alt1
Summary:       Library for mocking and stubbing in Ruby
License:       MIT or BSD-2-Clause
Group:         Development/Ruby
Url:           https://github.com/freerange/mocha
Vcs:           https://github.com/freerange/mocha.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(introspection) >= 0.0.1
BuildRequires: gem(minitest) >= 0
BuildRequires: gem(rake) >= 0
BuildConflicts: gem(introspection) >= 0.1
%if_enabled check
BuildRequires: gem(ruby2_keywords) >= 0.0.5
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Requires:      ruby >= 2.2
Requires:      gem(ruby2_keywords) >= 0.0.5
Obsoletes:     ruby-mocha < %EVR
Provides:      ruby-mocha = %EVR
Provides:      mocha = %EVR
Provides:      gem(mocha) = 2.7.1

%description
Mocha is a library for mocking and stubbing in Ruby using a syntax like that of
JMock. Mocha provides a unified, simple and readable syntax for both traditional
and partial mocking.


%if_enabled    doc
%package       -n gem-mocha-doc
Version:       2.7.1
Release:       alt1
Summary:       Library for mocking and stubbing in Ruby documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета mocha
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(mocha) = 2.7.1

%description   -n gem-mocha-doc
Library for mocking and stubbing in Ruby documentation files.

Mocha is a library for mocking and stubbing in Ruby using a syntax like that of
JMock. Mocha provides a unified, simple and readable syntax for both traditional
and partial mocking.

%description   -n gem-mocha-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета mocha.
%endif


%if_enabled    devel
%package       -n gem-mocha-devel
Version:       2.7.1
Release:       alt1
Summary:       Library for mocking and stubbing in Ruby development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета mocha
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(mocha) = 2.7.1
Requires:      gem(introspection) >= 0.0.1
Requires:      gem(minitest) >= 0
Requires:      gem(rake) >= 0
Conflicts:     gem(introspection) >= 0.1

%description   -n gem-mocha-devel
Library for mocking and stubbing in Ruby development package.

Mocha is a library for mocking and stubbing in Ruby using a syntax like that of
JMock. Mocha provides a unified, simple and readable syntax for both traditional
and partial mocking.

%description   -n gem-mocha-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета mocha.
%endif


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc CONTRIBUTING.md COPYING.md MIT-LICENSE.md README.md
%ruby_gemspec
%ruby_gemlibdir

%if_enabled    doc
%files         -n gem-mocha-doc
%doc CONTRIBUTING.md COPYING.md MIT-LICENSE.md README.md
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-mocha-devel
%doc CONTRIBUTING.md COPYING.md MIT-LICENSE.md README.md
%endif


%changelog
