%define        _unpackaged_files_terminate_build 1
%def_disable   check
%def_enable    doc
%def_disable   devel
%define        gemname highline

Name:          gem-highline
Epoch:         1
Version:       3.1.1
Release:       alt1
Summary:       HighLine is a high-level command-line IO Ruby library
License:       Ruby
Group:         Development/Ruby
Url:           https://github.com/JEG2/highline
Vcs:           https://github.com/jeg2/highline.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
%if_enabled check
BuildRequires: gem(bundler) >= 0
BuildRequires: gem(rake) >= 0
BuildRequires: gem(minitest) >= 0
BuildRequires: gem(dry-types) >= 0
BuildRequires: gem(simplecov) >= 0
BuildRequires: gem(flog) >= 0
BuildRequires: gem(pronto) >= 0
BuildRequires: gem(pronto-flay) >= 0
BuildRequires: gem(path_expander) = 1.1.1
BuildRequires: gem(pronto-reek) >= 0
BuildRequires: gem(pronto-rubocop) >= 0
BuildRequires: gem(reline) >= 0
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Requires:      gem(reline) >= 0
Obsoletes:     ruby-highline < %EVR
Provides:      ruby-highline = %EVR
Provides:      gem(highline) = 3.1.1


%description
A high-level IO library that provides validation, type conversion, and more for
command-line interfaces. HighLine also includes a complete menu system that can
crank out anything from simple list selection to complete shells with just
minutes of work.


%if_enabled    doc
%package       -n gem-highline-doc
Version:       3.1.1
Release:       alt1
Summary:       HighLine is a high-level command-line IO Ruby library documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета highline
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(highline) = 3.1.1

%description   -n gem-highline-doc
HighLine is a high-level command-line IO Ruby library documentation files.

A high-level IO library that provides validation, type conversion, and more for
command-line interfaces. HighLine also includes a complete menu system that can
crank out anything from simple list selection to complete shells with just
minutes of work.

%description   -n gem-highline-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета highline.
%endif


%if_enabled    devel
%package       -n gem-highline-devel
Version:       3.1.1
Release:       alt1
Summary:       HighLine is a high-level command-line IO Ruby library development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета highline
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(highline) = 3.1.1
Requires:      gem(bundler) >= 0
Requires:      gem(rake) >= 0
Requires:      gem(minitest) >= 0
Requires:      gem(dry-types) >= 0
Requires:      gem(simplecov) >= 0
Requires:      gem(flog) >= 0
Requires:      gem(pronto) >= 0
Requires:      gem(pronto-flay) >= 0
Requires:      gem(path_expander) = 1.1.1
Requires:      gem(pronto-reek) >= 0
Requires:      gem(pronto-rubocop) >= 0

%description   -n gem-highline-devel
HighLine is a high-level command-line IO Ruby library development package.

A high-level IO library that provides validation, type conversion, and more for
command-line interfaces. HighLine also includes a complete menu system that can
crank out anything from simple list selection to complete shells with just
minutes of work.

%description   -n gem-highline-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета highline.
%endif


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.md
%ruby_gemspec
%ruby_gemlibdir

%if_enabled    doc
%files         -n gem-highline-doc
%doc README.md
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-highline-devel
%doc README.md
%endif


%changelog
