%define        gemname gettext

Name:          gem-gettext
Version:       3.4.3
Release:       alt1
Summary:       Native Language Support Library for Ruby
License:       Ruby or LGPL-3.0+
Group:         Development/Ruby
Url:           https://ruby-gettext.github.io/
Vcs:           https://github.com/ruby-gettext/locale.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
%if_with check
BuildRequires: gem(kramdown) >= 0
BuildRequires: gem(racc) >= 0
BuildRequires: gem(rake) >= 0
BuildRequires: gem(red-datasets) >= 0
BuildRequires: gem(test-unit) >= 0
BuildRequires: gem(test-unit-rr) >= 0
BuildRequires: gem(yard) >= 0
BuildRequires: gem(erubi) >= 0
BuildRequires: gem(locale) >= 2.0.5
BuildRequires: gem(prime) >= 0
BuildRequires: gem(text) >= 1.3.0
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Requires:      gem(erubi) >= 0
Requires:      gem(locale) >= 2.0.5
Requires:      gem(prime) >= 0
Requires:      gem(text) >= 1.3.0
Obsoletes:     gem-gettext-cgi < %EVR
Obsoletes:     gem-gettext-erb < %EVR
Obsoletes:     ruby-gettext < %EVR
Provides:      gem-gettext-cgi = %EVR
Provides:      gem-gettext-erb = %EVR
Provides:      ruby-gettext = %EVR
Provides:      gem(gettext) = 3.4.3


%description
Ruby GetText Package is Native Language Support Library and Tools which modeled
after GNU gettext package.

Features: * Simple APIs(similar GNU gettext) * rgettext creates po-files from
ruby scripts. The po-file is compatible to GNU gettext. * rmsgfmt creates a
mo-file from a po-file.

This library was called as "Ruby-Locale". Since 2.0.6, this library is called
just "locale". You can call this library as "locale gem" or "Ruby Locale" to
distinguish from other "locale"s.

This library aims to support all environments which Ruby works and all kind of
programs (GUI, WWW, library, etc), and becomes the hub of other i18n/l10n
libs/apps to handle major locale ID standards.


%package       -n rmsg
Version:       3.4.3
Release:       alt1
Summary:       Native Language Support Library for Ruby executable(s)
Summary(ru_RU.UTF-8): Исполнямка для самоцвета gettext
Group:         Other
BuildArch:     noarch

Requires:      gem(gettext) = 3.4.3
Obsoletes:     gettext-gemtools < %EVR
Provides:      gettext-gemtools = %EVR

%description   -n rmsg
Native Language Support Library for Ruby executable(s).

Ruby GetText Package is Native Language Support Library and Tools which modeled
after GNU gettext package.

Features: * Simple APIs(similar GNU gettext) * rgettext creates po-files from
ruby scripts. The po-file is compatible to GNU gettext. * rmsgfmt creates a
mo-file from a po-file.

This library was called as "Ruby-Locale". Since 2.0.6, this library is called
just "locale". You can call this library as "locale gem" or "Ruby Locale" to
distinguish from other "locale"s.

This library aims to support all environments which Ruby works and all kind of
programs (GUI, WWW, library, etc), and becomes the hub of other i18n/l10n
libs/apps to handle major locale ID standards.

%description   -n rmsg -l ru_RU.UTF-8
Исполнямка для самоцвета gettext.


%package       -n gem-gettext-doc
Version:       3.4.3
Release:       alt1
Summary:       Native Language Support Library for Ruby documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета gettext
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(gettext) = 3.4.3

%description   -n gem-gettext-doc
Native Language Support Library for Ruby documentation files.

Ruby GetText Package is Native Language Support Library and Tools which modeled
after GNU gettext package.

Features: * Simple APIs(similar GNU gettext) * rgettext creates po-files from
ruby scripts. The po-file is compatible to GNU gettext. * rmsgfmt creates a
mo-file from a po-file.

This library was called as "Ruby-Locale". Since 2.0.6, this library is called
just "locale". You can call this library as "locale gem" or "Ruby Locale" to
distinguish from other "locale"s.

This library aims to support all environments which Ruby works and all kind of
programs (GUI, WWW, library, etc), and becomes the hub of other i18n/l10n
libs/apps to handle major locale ID standards.

%description   -n gem-gettext-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета gettext.


%package       -n gem-gettext-devel
Version:       3.4.3
Release:       alt1
Summary:       Native Language Support Library for Ruby development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета gettext
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(gettext) = 3.4.3
Requires:      gem(kramdown) >= 0
Requires:      gem(racc) >= 0
Requires:      gem(rake) >= 0
Requires:      gem(red-datasets) >= 0
Requires:      gem(test-unit) >= 0
Requires:      gem(test-unit-rr) >= 0
Requires:      gem(yard) >= 0

%description   -n gem-gettext-devel
Native Language Support Library for Ruby development package.

Ruby GetText Package is Native Language Support Library and Tools which modeled
after GNU gettext package.

Features: * Simple APIs(similar GNU gettext) * rgettext creates po-files from
ruby scripts. The po-file is compatible to GNU gettext. * rmsgfmt creates a
mo-file from a po-file.

This library was called as "Ruby-Locale". Since 2.0.6, this library is called
just "locale". You can call this library as "locale gem" or "Ruby Locale" to
distinguish from other "locale"s.

This library aims to support all environments which Ruby works and all kind of
programs (GUI, WWW, library, etc), and becomes the hub of other i18n/l10n
libs/apps to handle major locale ID standards.

%description   -n gem-gettext-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета gettext.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.md
%ruby_gemspec
%ruby_gemlibdir

%files         -n rmsg
%doc README.md
%_bindir/rmsgcat
%_bindir/rmsgfmt
%_bindir/rmsginit
%_bindir/rmsgmerge
%_bindir/rxgettext

%files         -n gem-gettext-doc
%doc README.md
%ruby_gemdocdir

%files         -n gem-gettext-devel
%doc README.md


%changelog
