%def_disable snapshot

%ifndef _priority_distbranch
%define altbranch `rpm --eval %_priority_distbranch`
%else
%define altbranch %_priority_distbranch
%endif
%ifndef altbranch
%define altbranch sisyphus
%endif

%define ver_major 49
%define beta %nil
%define api_ver 1.0

%define _libexecdir %_prefix/libexec
%define _localstatedir %_var

%define default_pam_config redhat
# Initial virtual terminal to use
%define vt_nr 1

%def_disable static
%def_disable debug
%def_enable ipv6
%def_with xdmcp
%def_with selinux
%def_with libaudit
%def_with plymouth
%def_enable wayland
%def_enable x11
%def_enable xsession
#Enable running X server as user
%def_enable user_display_server
%def_enable check

Name: gdm
Version: %ver_major.1
Release: alt1%beta

Summary: The GNOME Display Manager
License: GPL-2.0-or-later
Url: http://wiki.gnome.org/Projects/GDM
Group: Graphical desktop/GNOME

Vcs: https://gitlab.gnome.org/GNOME/gdm.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

Source1: gdm_xdmcp-45.0.control

# PAM config files
Source10: gdm.pam
Source11: gdm-autologin.pam
Source12: gdm-password.pam
Source13: gdm-launch-environment.pam
Source14: gdm-smartcard.pam
Source15: gdm-fingerprint.pam

Patch2: gdm-40.beta-alt-Xsession.patch
Patch7: gdm-40.beta-alt-Init.patch
# replace xterm by x-terminal-emulator (ALT #40031)
Patch8: gdm-44.1-alt-Xsession-Xterm.patch
# for p11
Patch9: gdm-48-Revert-Disable-Xorg-session-by-default.patch

Obsoletes: %name-gnome
Provides: %name-gnome = %EVR
Provides: gnome-dm

%define gdm_subconfdir %name
%define gdm_confdir %_sysconfdir/%name

# from meson.build
%define glib_ver 2.56.0
%define gtk_ver 3.16.0
%define shell_ver 48
%define libcanberra_ver 0.4
%define accountsservice_ver 0.6.35
%define check_ver 0.9.4
%define session_ver 40
%define gudev_ver 232

Provides: %name-user-switch-applet = %EVR
Obsoletes: %name-user-switch-applet

Requires(pre): %_rpmlibdir/update-dconf-database.filetrigger
Requires(pre): %name-libs = %EVR
Requires(pre): %name-data = %EVR
Requires: gnome-shell >= %shell_ver
Requires: accountsservice >= %accountsservice_ver
Requires: coreutils iso-codes lsb-release shadow-utils
Requires: gnome-session >= %session_ver
#Requires: gnome-session-wayland
Requires: /bin/dbus-run-session

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires(pre): rpm-build-gir rpm-macros-pam0 rpm-build-systemd
BuildRequires: meson gcc-c++ desktop-file-utils gnome-common yelp-tools
BuildRequires: iso-codes-devel
BuildRequires: glib2-devel >= %glib_ver libgio-devel
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libaccountsservice-devel >= %accountsservice_ver
BuildRequires: libgudev-devel >= %gudev_ver
BuildRequires: dconf pkgconfig(systemd) libpam-devel
%{?_with_selinux:BuildRequires: libselinux-devel libattr-devel}
%{?_with_libaudit:BuildRequires: libaudit-devel}
%{?_with_plymouth:BuildRequires: plymouth-devel}
BuildRequires: libcanberra-devel >= %libcanberra_ver libcanberra-gtk3-devel

%{?_enable_x11:
BuildRequires: libX11-devel libXau-devel libXrandr-devel libXext-devel libXft-devel libSM-devel
BuildRequires: libXi-devel xorg-proto-devel libXinerama-devel xorg-sdk
BuildRequires: xorg-xephyr xorg-server
BuildRequires: libdmx-devel
BuildRequires: libXdmcp-devel
BuildRequires: libkeyutils-devel}

BuildRequires: libcheck-devel >= %check_ver
BuildRequires: librsvg-devel perl-XML-Parser docbook-dtds xsltproc zenity
BuildRequires: gobject-introspection-devel
BuildRequires: libdaemon-devel libudev-devel
BuildRequires: pkgconfig(dconf) pkgconfig(json-glib-1.0)
%{?_enable_check:BuildRequires: /proc dbus-tools-gui}

%description
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

%package data
Summary: Arch independent files for GDM
Group: Graphical desktop/GNOME
BuildArch: noarch
Conflicts: gdm2.20

%description data
This package provides noarch data needed for GDM to work.

%package libs
Summary: GDM libraries
Group: System/Libraries

%description -n %name-libs
This package contains shared libraries needed for GNOME Display Manager
to work.

%package libs-devel
Summary: Development files for GDM libraries
Group: Development/C
Requires: %name-libs = %EVR

%description libs-devel
This package contains headers and development libraries for GNOME
Display Manager.

%package libs-gir
Summary: GObject introspection data for the GDM
Group: System/Libraries
Requires: %name-libs = %EVR

%description libs-gir
GObject introspection data for the GDM libraries.

%package libs-gir-devel
Summary: GObject introspection devel data for the GDM
Group: Development/Other
BuildArch: noarch
Requires: %name-libs-gir = %EVR
Requires: %name-libs-devel = %EVR

%description libs-gir-devel
GObject introspection devel data for the GDM libraries.

%package help
Summary: User documentation for Gdm
Group: Graphical desktop/GNOME
BuildArch: noarch
Conflicts: %name < %version-%release

%description help
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

This package contains user documentation for Gdm.

%prep
%setup -n %name-%version%beta
%patch2 -p1 -b .XSession
%patch7 -p1 -b .Init
%patch8 -p1 -b .XSession-Xterm
if [ "%altbranch" != sisyphus ]; then
%patch9 -p1 -b .Revert-Disable
fi

# just copy our PAM config files to %default_pam_config directory
cp %SOURCE10 %SOURCE11 %SOURCE12 %SOURCE13 %SOURCE14 %SOURCE15  data/pam-%default_pam_config/

%build
# to find /sbin/nologin
export PATH=$PATH:/sbin
%meson \
    %{subst_enable_meson_bool ipv6 ipv6} \
    -Drun-dir=/run/gdm \
    -Dinitial-vt='%vt_nr' \
    -Ddefault-path='/bin:/usr/bin:/usr/local/bin' \
    -Dsysconfsubdir='%gdm_subconfdir' \
    -Dpam-prefix='%_sysconfdir' \
    -Dpam-mod-dir='%_pam_modules_dir' \
    -Ddefault-pam-config='%default_pam_config' \
    -Ddmconfdir='%_sysconfdir/X11/sessions' \
    -Dudev-dir='%_udevrulesdir' \
    -Ddbus-sys='%_datadir/dbus-1/system.d' \
    %{?_without_xdmcp:-Dxdmcp=disabled} \
    %{?_without_libaudit:-Dlibaudit=disabled} \
    %{?_without_plymouth:-Dplymouth=disabled} \
    %{subst_enable_meson_bool wayland wayland-support} \
    %{subst_enable_meson_bool x11 x11-support} \
    %{subst_enable_meson_bool xsession gdm-xsession} \
    %{subst_enable_meson_bool user_display_server user-display-server}
%nil
%meson_build

%install
mkdir -p %buildroot%_sysconfdir/X11/sessions

%meson_install
rm -f %buildroot%_sysconfdir/pam.d/gdm

# env.d directories
mkdir -p %buildroot{%gdm_confdir,%_datadir/%name}/env.d

%{?_enable_x11:
# control gdm/xdmcp
install -pDm755 %SOURCE1 %buildroot%_controldir/gdm_xdmcp}

%find_lang %name
%find_lang --output=%name-help.lang --without-mo --with-gnome %name

%check
dbus-run-session %__meson_test

%if_enabled x11
%pre
%pre_control gdm_xdmcp

%post
%post_control -s disabled gdm_xdmcp
%endif

%files
%_sbindir/gdm
%_bindir/gdm-config
%_bindir/gdmflexiserver
%{?_enable_x11:%_libexecdir/gdm-host-chooser
%_libexecdir/gdm-simple-chooser
%_libexecdir/gdm-x-session}
%_libexecdir/gdm-session-worker
%_libexecdir/gdm-wayland-session
%_libexecdir/gdm-runtime-config
%exclude %_libexecdir/gdm-auth-config-redhat
%_pam_modules_dir/pam_gdm.so
%_unitdir/gdm.service
%_userunitdir/gnome-session@gnome-login.target.d/gnome-login.session.conf
%doc AUTHORS NEWS README*

%files data -f %name.lang
%config %_sysconfdir/pam.d/gdm-autologin
%config %_sysconfdir/pam.d/gdm-password
%config %_sysconfdir/pam.d/gdm-launch-environment
%config %_sysconfdir/pam.d/gdm-smartcard
%config %_sysconfdir/pam.d/gdm-fingerprint
%_datadir/dbus-1/system.d/%name.conf
%config %_datadir/polkit-1/rules.d/20-%name.rules
%config %_datadir/glib-2.0/schemas/org.gnome.login-screen.gschema.xml
%dir %gdm_confdir
%config(noreplace) %gdm_confdir/custom.conf
%{?_enable_x11:%gdm_confdir/Xsession}
%gdm_confdir/env.d/
%gdm_confdir/Init/
%gdm_confdir/PostLogin/
%gdm_confdir/PostSession/
%gdm_confdir/PreSession/

%{?_enable_x11:%config %_controldir/gdm_xdmcp}
%dir %_datadir/%name
%_datadir/%name/locale.alias
%_datadir/%name/gdb-cmd
%_datadir/%name/%name.schemas
%dir %_datadir/%name/greeter
%dir %_datadir/%name/greeter/applications
%_datadir/%name/greeter-dconf-defaults
%_datadir/gnome-session/sessions/gnome-login.session
%_datadir/dconf/profile/%name
%_datadir/gdm/greeter/applications/mime-dummy-handler.desktop
%_datadir/gdm/greeter/applications/mimeapps.list

%files help -f %name-help.lang

%files libs
%_libdir/libgdm.so.*

%files libs-devel
%_includedir/gdm/
%_libdir/libgdm.so
%_pkgconfigdir/%name.pc
%_pkgconfigdir/%name-pam-extensions.pc

%files libs-gir
%_typelibdir/Gdm-%api_ver.typelib

%files libs-gir-devel
%_girdir/Gdm-%api_ver.gir


%changelog
