%def_enable tui
%def_with debuginfod
%def_disable check
%def_with python
%def_enable gdbserver

Name: gdb
Version: 14.1.0.56.d739d4fd457
Release: alt1

Summary: A GNU source-level debugger for C, C++ and other languages
License: GPLv3+
Group: Development/Debuggers
Url: http://www.gnu.org/software/gdb/

# http://git.altlinux.org/gears/g/gdb.git
Source: gdb-%version-%release.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: flex libreadline-devel libexpat-devel liblzma-devel zlib-devel libgmp-devel libmpfr-devel
BuildRequires: gcc-c++
BuildRequires: makeinfo
BuildRequires: %{?_with_python:python3-devel} %{?_enable_tui:libncursesw-devel} %{?_with_debuginfod:libdebuginfod-devel}
%{?!_without_check:%{?!_disable_check:BuildRequires: dejagnu glibc-devel-static gcc-c++ gcc-fortran gcc-objc prelink valgrind /proc /dev/pts}}
Requires: gdb-common = %version-%release

%description
GDB is a full featured, command driven debugger.  GDB allows you to
trace the execution of programs and examine their internal state at
any time.  The debugger is most effective when used together with a
supported compiler, such as those from the GNU Compiler Collection.

%package -n gdbserver
Summary: A standalone server for GDB (the GNU source-level debugger)
Group: Development/Debuggers

%description -n gdbserver
GDB, the GNU debugger, allows you to debug programs written in C, C++,
Java, and other languages, by executing them in a controlled fashion and
printing their data.
This package provides a program that allows you to run GDB on a
different machine than the one which is running the program being
debugged.


%package light
Summary: A GNU source-level debugger for C, C++ and other languages (light build)
Group: Development/Debuggers
Requires: gdb-common = %version-%release
Conflicts: gdb < 7.5.0.20121002-alt5

%description light
GDB is a full featured, command driven debugger.  GDB allows you to
trace the execution of programs and examine their internal state at
any time.  The debugger is most effective when used together with a
supported compiler, such as those from the GNU Compiler Collection.
This package contains light build of GDB without expat, python and
tui support.

%package common
Summary: GDB common files
Group: Development/Debuggers
BuildArch: noarch
Conflicts: gdb < 7.5.0.20121002-alt5

%description common
This package contains common GDB files.

%package -n libgdb-devel
Summary: GDB static libraries
Group: Development/C
Conflicts: libbfd-devel libiberty-devel

%description -n libgdb-devel
This package contains static GDB libraries required to build other debuggers.

%prep
%setup -n %name-%version-%release
# Remove generated bison and flex parser files.
egrep -lZ 'A (Bison parser, made by GNU Bison|lexical scanner generated by flex)' gdb/*.c |
	xargs -r0 rm --

# Somehow readline/doc is needed to build other docs.
mv readline/readline/doc readline-doc

# We want to use these as system libraries.
rm -r readline zlib

find -type f -name \*.orig -delete
xz -9k gdb/{MAINTAINERS,NEWS}

%build
echo '%version-%release (%distribution)' >gdb/version.in

for f in */configure.ac; do
	pushd "${f%%/*}"
		[ configure.in -nt configure ] && autoconf
	popd
done
for f in */Makefile.am; do
	pushd "${f%%/*}"
		[ Makefile.am -nt Makefile.in ] && automake
	popd
done

%define _configure_script ../configure

set -- \
	--with-gdb-datadir=%_datadir/gdb \
	--with-separate-debug-dir=/usr/lib/debug \
	--with-auto-load-dir='$debugdir:%_libdir/gdb/auto-load:$datadir/auto-load' \
	--enable-gdb-build-warnings=,-Wno-unused \
	--disable-werror \
	--disable-sim \
	--disable-rpath \
	--with-system-readline \
	--with-lzma \
	--without-libexpat-prefix \
	--without-libunwind \
	--enable-64-bit-bfd \
	--with-system-zlib \
	#

export \
	ac_cv_have_x=${ac_cv_have_x='have_x=yes ac_x_includes=%_x11includedir ac_x_libraries=%_x11libdir'} \
	%{?!_enable_tui:ac_cv_search_tgetent='none required'} \
	#

%define buildtarget build-%_target
rm -rf %buildtarget
mkdir %buildtarget
pushd %buildtarget

%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%configure \
	"$@" \
	%{subst_enable tui} \
	%{subst_with debuginfod} \
%if_with python
	--with-python=python3 \
%endif
	#

%make_build
%make_build -C gdb libgdb.a
%make_build info MAKEINFOFLAGS=--no-split

popd #%buildtarget

rm -rf light
mkdir light
pushd light

%configure \
	"$@" \
	--disable-tui \
	--without-expat \
	--without-python \
	--without-debuginfod \
	#
%make_build

popd #light

%install
%makeinstall_std -C %buildtarget
install -pm755 light/gdb/gdb %buildroot%_bindir/gdb-light

install -pm644 alt/gdb-gstack.man %buildroot%_man1dir/gstack.1

# These files are already packaged as a part of binutils.
rm %buildroot%_infodir/bfd*
rm %buildroot%_infodir/ctf*
rm %buildroot%_infodir/sframe*
rm %buildroot%_datadir/locale/*/LC_MESSAGES/{bfd,opcodes}.mo

pushd %buildtarget
mkdir -p %buildroot%_libdir
install -pm644 */lib*.a %buildroot%_libdir/
popd #%buildtarget

mkdir -p %buildroot%_datadir/gdb/auto-load

rm %buildroot/%_datadir/gdb/system-gdbinit/elinos.py
rm %buildroot/%_datadir/gdb/system-gdbinit/wrs-linux.py
rmdir %buildroot/%_datadir/gdb/system-gdbinit

# These are provided by the gdb binary.
%add_python3_req_skip _gdb
%add_python3_req_skip _gdbevents
%add_python3_req_skip _gdb.disassembler
%add_python3_path %_datadir/gdb/python

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%check
[ -w /dev/ptmx -a -f /proc/self/maps ] || exit
pushd %buildtarget/gdb
cc %optflags -o orphanripper alt/gdb-orphanripper.c -lutil
./orphanripper make -k -j%__nprocs check ||:
popd

%pre
# gdb-8.2.50.20180917-alt1 switched from a symlink (to Python2 site-libdir)
# to a normal directory (with Python3 code). Give way to the directory:
l=%_datadir/gdb/python/gdb
if [ -L "$l" ]; then
    rm -v "$l"
fi

%files
%_bindir/*
%if_with python
%_datadir/gdb/python
%endif
%exclude %_bindir/gdb-light
%if_enabled gdbserver
%exclude %_bindir/gdbserver

%files -n gdbserver
%_bindir/gdbserver
# no ipa_obj for arm* and mips*
%ifnarch armh %mips loongarch64
%_libdir/libinproctrace.so
%endif
%endif

%files light
%_bindir/gdb-light

%files common
%_man1dir/*
%_infodir/*
%_datadir/gdb
%doc gdb/{MAINTAINERS,NEWS}.xz
%exclude %_datadir/gdb/python

%files -n libgdb-devel
%_includedir/*
%_libdir/lib*.a

%changelog
