%define ver_major 3.0
%define xdg_name org.gnome.gconf-editor

Name: gconf-editor
Version: %ver_major.1
Release: alt2

Summary: An editor for the GConf configuration system.
License: GPLv2+
Group: Graphical desktop/GNOME
Url: ftp://ftp.gnome.org

#Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
Source: %name-%version.tar

%define GConf_ver 2.32.1-alt2
%define gtk_ver 3.0.5

Requires(post,preun): GConf >= %GConf_ver

BuildPreReq: rpm-build-gnome >= 0.5 gnome-common
# From configure.in
BuildPreReq: intltool >= 0.35.0 librarian gnome-doc-utils
BuildPreReq: libGConf-devel >= %GConf_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildRequires: libgio-devel

%description
An editor for the GConf configuration system.
Directly edit your entire configuration database.

%prep
%setup

%build
gnome-doc-prepare -f
%autoreconf
%configure --disable-scrollkeeper \
    --disable-schemas-install

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%post
%gconf2_install %name

%preun
if [ $1 = 0 ]; then
    %gconf2_uninstall %name
fi

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%_iconsdir/*/*/*/*
%_man1dir/*
%_datadir/%name
%config %gconf_schemasdir/*
%_datadir/appdata/%xdg_name.appdata.xml
%doc AUTHORS NEWS README

%changelog
