%define _unpackaged_files_terminate_build 1

Name: gcc-common
Version: 1.4.28
Release: alt1

Summary: Common directories, symlinks and selection utility for the GNU Compiler Collection
License: GPL-2.0-or-later
Group: Development/C
Url: http://git.altlinux.org/gears/g/gcc-common.git

Source: gcc_wrapper.c

%define _libexecdir /usr/libexec

%ifarch ppc
# On powerpc, even though target is ppc32, compiler is inherently 64-bit,
# thus the wrapper should call ppc64-alt-linux-*.
%define _target_platform ppc64-alt-linux
%endif

%ifarch %e2k
# On e2k we are using command names such as %%_configure_platform-gcc.
# %%_configure_platform is a normalized (short) %%_target_platform, which
# on e2k is being stripped off the CPU modification/optimization.
%define _platform %_configure_platform
%else
%define _platform %_target_platform
%endif

%package -n gcc-c++-common
Summary: Common symlinks for the GNU C++ Compiler
License: GPL-2.0-or-later
Group: Development/C++
BuildArch: noarch
PreReq: %name = %version-%release

%package -n gcc-gdc-common
Summary: Common symlinks for the GNU D Compiler
License: GPL-2.0-or-later
Group: Development/Other
BuildArch: noarch
PreReq: %name = %version-%release

%package -n gcc-go-common
Summary: Common symlinks for the Go Compiler
License: GPL-2.0-or-later
Group: Development/Other
BuildArch: noarch
PreReq: %name = %version-%release

%package -n gcc-fortran-common
Summary: Common symlinks for the GNU Fortran Compiler
License: GPL-2.0-or-later
BuildArch: noarch
Group: Development/Other
PreReq: %name = %version-%release
Provides: gcc-g77-common = %version-%release
Obsoletes: gcc-g77-common
Conflicts: gcc2.95-g77 < 1:2.95.3-alt8
Conflicts: gcc2.96-g77 < 0:2.96-alt8
Conflicts: gcc3.3-g77 < 0:3.3.4-alt5
Conflicts: gcc3.4-g77 < 0:3.4.5-alt3

%package -n gcc-treelang-common
Summary: Common symlinks for the GNU Treelang Compiler
License: GPL-2.0-or-later
Group: Development/Other
BuildArch: noarch
PreReq: %name = %version-%release
Conflicts: gcc3.3-treelang < 0:3.3.4-alt5
Conflicts: gcc3.4-treelang < 0:3.4.5-alt3

%package -n gcc-gnat-common
Summary: Common symlinks for the GNU Ada compiler (GNAT)
License: GPL-2.0-or-later
Group: Development/Other
BuildArch: noarch
PreReq: %name = %version-%release
Conflicts: gcc4.7-gnat gcc4.6-gnat gcc4.5-gnat gcc4.4-gnat gcc4.3-gnat gcc4.2-gnat gcc4.1-gnat

%description
This package contains common symlinks, directories and selection
utility for the GNU Compiler Collection.

%description -n gcc-c++-common
This package contains common symlinks for the GNU C++ Compiler.

%description -n gcc-gdc-common
This package contains common symlinks for the GNU D Compiler.

%description -n gcc-go-common
This package contains common symlinks for the Go Compiler.

%description -n gcc-fortran-common
This package contains common symlinks for the GNU Fortran 77 Compiler.

%description -n gcc-treelang-common
This package contains common symlinks for the GNU Treelang Compiler.

%description -n gcc-gnat-common
This package contains common symlinks for the GNU Ada compiler (GNAT).

%prep
%setup -cT
%ifarch %e2k
%add_optflags -fwhole -g0
%else
%add_optflags -O3 -fwhole-program
%endif

%build
build_with()
{
"$1" %optflags -Werror '-DBINDIR="%_bindir"' \
	'-DTARGET="%_platform"' %_sourcedir/gcc_wrapper.c -o gcc_wrapper
}

# Directly access the compiler (not via gcc -> gcc_wrapper;
# in case of errors in the previous build of this package).
# And fallback to the default command--in case this is a bootstrap build.
%global __cc_directly %_platform-gcc%{?_gcc_version:-%_gcc_version}
build_with %__cc_directly ||
build_with %__cc

%install
mkdir -p %buildroot{/lib,%_libdir/gcc{,-lib}/%_platform,%_libexecdir/gcc/%_platform,%_bindir,%_includedir/c++}
install -p -m755 gcc_wrapper %buildroot%_bindir/

ln -s gcc_wrapper %buildroot%_bindir/gcc

%ifarch %e2k
for n in cc cpp g++ gcc-{ar,nm,ranlib} gcov gfortran; do
%else
for n in cc cpp g++ gcc-{ar,nm,ranlib} gccgo gcov gdc gfortran gnat gtreelang lto-dump protoize unprotoize; do
%endif
	ln -s gcc "%buildroot%_bindir/$n"
done
%ifnarch %e2k
for n in dump tool; do
	ln -s gcov "%buildroot%_bindir/gcov-$n"
done
%endif
for n in f77 f95 g77; do
	ln -s gfortran "%buildroot%_bindir/$n"
done
%ifnarch %e2k
for n in gnatbind gnatchop gnatclean gnatfind gnatgcc gnatkr gnatlink gnatls gnatmake gnatname gnatprep gnatxref; do
	ln -s gnat "%buildroot%_bindir/$n"
done
%endif

ln -s g++ %buildroot%_bindir/c++
%ifnarch %e2k
ln -s gtreelang %buildroot%_bindir/tree1
%endif

%check
which %__cc_directly || { echo 'Skipping the test of gcc_wrapper.'; exit 0; }
%{?_gcc_version:export GCC_VERSION=%_gcc_version}
%buildroot%_bindir/gcc_wrapper --version
%buildroot%_bindir/gcc --version
%buildroot%_bindir/cpp --version

%package checkinstall
Summary: Installing me immediately runs the test for gcc_wrapper
Group: Development/C
PreReq: %name = %EVR
# An error in gcc_wrapper can already be caught as an UNMET dependency.
PreReq: %_bindir/%__cc_directly

%description checkinstall
By installing this package, you immediately run the test for gcc_wrapper.

%files checkinstall

%pre checkinstall
%{?_gcc_version:export GCC_VERSION=%_gcc_version}
gcc_wrapper --version
gcc --version
cpp --version

%files
%_libdir/gcc*
%_libexecdir/gcc*
%_bindir/gcc_wrapper
%_bindir/cc
%_bindir/cpp
%_bindir/gcc
%_bindir/gcc-ar
%_bindir/gcc-nm
%_bindir/gcc-ranlib
%_bindir/gcov
%ifnarch %e2k
%_bindir/gcov-tool
%_bindir/gcov-dump
%_bindir/lto-dump
%_bindir/protoize
%_bindir/unprotoize
%endif

%files -n gcc-c++-common
%_bindir/c++
%_bindir/g++
%_includedir/c++

%ifnarch %e2k
%files -n gcc-gdc-common
%_bindir/gdc
%endif

%files -n gcc-fortran-common
%_bindir/f77
%_bindir/f95
%_bindir/g77
%_bindir/gfortran

%ifnarch %e2k
%files -n gcc-go-common
%_bindir/gccgo

%files -n gcc-treelang-common
%_bindir/gtreelang
%_bindir/tree1

%files -n gcc-gnat-common
%_bindir/gnat*
%endif

%changelog
