%define repo autpgrp

Name: gap-autpgrp
Summary: GAP: Computing the Automorphism Group of a p-Group
License: GPL-2.0-or-later
Group: Sciences/Mathematics
Version: 1.11.1
Release: alt2
Url: https://gap-packages.github.io/autpgrp/
VCS: https://github.com/gap-packages/autpgrp

# Source-url: https://github.com/gap-packages/autpgrp/releases/download/v%version/autpgrp-%version.tar.gz
Source: autpgrp-%version.tar
Patch: autpgrp-%version-%release.patch

BuildPreReq: rpm-macros-gap

BuildArch: noarch
Requires: gap >= 4.4

%description
The AutPGrp package introduces a new function to compute the
automorphism group of a finite $p$-group. The underlying algorithm is
a refinement of the methods described in O'Brien (1995). In
particular, this implementation is more efficient in both time and
space requirements and hence has a wider range of applications than
the ANUPQ method.

%prep
%setup -n autpgrp
%patch -p1

%build
%install
%gappkg_simple_install

%files -f %name.files
%gap_sitelib/%repo/

%changelog
