# missed typelib(AppIndicator3) in the repo
%def_without appindicator

Name: gammastep
Version: 2.0.10
Release: alt1

Summary: Adjusts the color temperature of your screen according to time of day

License: GPL-3.0-or-later AND MIT
Group: System/Configuration/Hardware
Url: https://gitlab.com/chinstrap/gammastep

# Source0-url: %url/-/archive/v%version/%name-v%version.tar.gz
Source0: %name-%version.tar


BuildRequires: rpm-build-intro

BuildRequires: desktop-file-utils
BuildRequires: intltool
BuildRequires: libappstream-glib
BuildRequires: pkgconfig(gio-2.0) >= 2.26
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(gobject-2.0)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-scanner) >= 1.15.0
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcb)
BuildRequires: pkgconfig(xcb-randr)
BuildRequires: pkgconfig(xxf86vm)
BuildRequires: python3-devel >= 3.2

Requires: hicolor-icon-theme

%description
Gammastep adjusts the color temperature of your screen according to your
surroundings. This may help your eyes hurt less if you are working in front
of the screen at night.

The color temperature is set according to the position of the sun. A different
color temperature is set during night and daytime. During twilight and early
morning, the color temperature transitions smoothly from night to daytime
temperature to allow your eyes to slowly adapt.

Gammastep supports wlr-gamma-control-unstable-v1 protocol for wlroots-based
wayland compositors.

%package indicator
Summary: GTK indicator applet for %name
Group: System/Configuration/Hardware

BuildArch: noarch

Requires: %name = %EVR
#Requires: libgtk+3
#Requires: libappindicator-libgtk+3
#Requires: python3dist(pygobject)
#Requires: python3dist(pyxdg)

%description indicator
This package provides a status icon for %name that allows the user
to control color temperature.

%prep
%setup

%build
./bootstrap
%configure \
    --with-systemduserunitdir=%_userunitdir
%make_build

%install
%makeinstall_std
%find_lang %name

%check
appstream-util validate-relax --nonet %buildroot%_metainfodir/*.appdata.xml
desktop-file-validate %buildroot%_desktopdir/*.desktop

%files -f %name.lang
%doc COPYING
%doc README.md %name.conf.sample
%_bindir/%name
%_man1dir/%name.1*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%_userunitdir/%name.service

%if_with appindicator
%files indicator
%_bindir/%name-indicator
%_desktopdir/%name-indicator.desktop
%_iconsdir/hicolor/scalable/apps/%name-status-*.svg
%_metainfodir/%name-indicator.appdata.xml
%_userunitdir/%name-indicator.service
%python3_sitelibdir_noarch/%{name}_indicator/
%endif

%changelog
