%define _unpackaged_files_terminate_build 1

Name: galera
Version: 26.4.24
Release: alt1
Summary: Synchronous multi-master wsrep provider (replication engine)
Group: System/Servers
License: GPLv2
Url: http://galeracluster.com/
# VCS-git: https://github.com/codership/galera.git
Source: %name-%version.tar

Source1: garbd.init
Source2: garbd.service
Source3: garbd.tmpfiles
Source4: garbd.conf

# git submodules
Source100: wsrep.tar

Patch: %name-%version.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake ctest
BuildRequires: boost-devel boost-program_options-devel boost-signals-devel
BuildRequires: asio-devel
BuildRequires: libcheck-devel libssl-devel zlib-devel

%description
Galera is a fast synchronous multi-master wsrep provider (replication engine)
for transactional databases and similar applications. For more information
about wsrep API see http://launchpad.net/wsrep. For a description of Galera
replication engine see http://www.codership.com.

%package garbd
Summary: Galera arbitrator
Group: System/Servers

%description garbd
Galera is a fast synchronous multi-master wsrep provider (replication engine)
for transactional databases and similar applications. For more information
about wsrep API see http://launchpad.net/wsrep. For a description of Galera
replication engine see http://www.codership.com.

This package contain Galera arbitrator.

%package -n libgalera_smm
Summary: Synchronous multi-master wsrep provider (replication engine)
Group: System/Libraries

%description -n libgalera_smm
Galera is a fast synchronous multi-master wsrep provider (replication engine)
for transactional databases and similar applications. For more information
about wsrep API see http://launchpad.net/wsrep. For a description of Galera
replication engine see http://www.codership.com.

%prep
%setup
tar -xf %SOURCE100 -C wsrep/src
%patch -p1
echo %release > GALERA_GIT_REVISION

%build
%cmake
%cmake_build

%install
%cmake_install
rm -rf %buildroot/usr/doc
rm -rf %buildroot/usr/share/garb*
install -D -m 755 %SOURCE1 %buildroot%_initdir/garbd
install -D -m 644 %SOURCE2 %buildroot%_unitdir/garbd.service
mkdir -p %buildroot{%_localstatedir,%_logdir}/garbd
install -D -m 644 %SOURCE3 %buildroot%_tmpfilesdir/garbd.conf
install -D -m 644 %SOURCE4 %buildroot%_sysconfdir/garbd/garbd.conf
#install -D -m 755 garb/garbd %%buildroot%%_sbindir/garbd
#install -D -m 644 libgalera_smm.so %%buildroot%%_libdir/galera/libgalera_smm.so
install -D -m 644 COPYING %buildroot%_docdir/galera/COPYING
install -D -m 644 scripts/packages/README %buildroot%_docdir/galera/README
install -D -m 644 scripts/packages/README-MySQL %buildroot%_docdir/galera/README-MySQL

%check
%cmake_build --target test

%pre garbd
groupadd -r -f _garbd
useradd -r -g _garbd -c "Galera Arbitrator Daemon" -d %_localstatedir/garbd -s /dev/null -M -N _garbd >/dev/null 2>&1 ||:

%post garbd
%post_service garbd

%preun garbd
%preun_service garbd

%files -n libgalera_smm
%dir %_libdir/galera
%_libdir/galera/libgalera_smm.so

%files garbd
%dir %_sysconfdir/garbd
%config(noreplace) %_sysconfdir/garbd/garbd.conf
%dir %_docdir/galera
%attr(0750,_garbd,_garbd) %dir %_localstatedir/garbd
%attr(3770,root,_garbd) %dir %_logdir/garbd
%_sbindir/garbd
%_man8dir/garbd.*
%_unitdir/garbd.service
%_initdir/garbd
%_tmpfilesdir/garbd.conf
%doc %_docdir/galera/COPYING
%doc %_docdir/galera/README
%doc %_docdir/galera/README-MySQL

%changelog
