%define _unpackaged_files_terminate_build 1

Name: fwupd-efi
Version: 1.7
Release: alt1.1
License: LGPLv2+

Group: System/Configuration/Hardware
Url: https://github.com/fwupd/fwupd-efi
Summary: EFI Application used by uefi-capsule plugin in fwupd

Packager: Egor Ignatov <egori@altlinux.org>

Source: %name-%version.tar
Patch0: %name-%version-alt.patch
ExclusiveArch: x86_64 aarch64 loongarch64 riscv64

BuildRequires: meson
BuildRequires: gnu-efi
BuildRequires: python3-module-pefile

%description
fwupd-efi is the UEFI binary used with fwupd for installing UEFI
firmware updates.

%package checkinstall
Group: System/Configuration/Hardware
Summary: Verify EFI signature
Requires: %name = %EVR
Requires(post): rpm-pesign-checkinstall

%description checkinstall
fwupd-efi is the UEFI binary used with fwupd for installing UEFI
firmware updates.

This package enables EFI signature verification.

%prep
%setup
%patch0 -p1

%build
%meson \
    -Defi-ldsdir="%_libdir" \
    -Defi_sbat_distro_id="altlinux" \
    -Defi_sbat_distro_summary="ALT Linux" \
    -Defi_sbat_distro_pkgname="%name" \
    -Defi_sbat_distro_version="%version-%release" \
    -Defi_sbat_distro_url="http://git.altlinux.org/gears/f/%{name}.git"

%meson_build

%install
%meson_install

%files
%attr(644, root, root) %_libdir/efi/fwupd*.efi
%_libdir/pkgconfig/fwupd-efi.pc

%ifnarch loongarch64 riscv64
%files checkinstall
%endif

%changelog
