%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%global sover 3

%global glib2_version 2.72.0
%global libxmlb_version 0.3.19
%global libusb_version  0.1.12
%global libcurl_version 7.62.0
%global libjcat_version 0.2.0
%global systemd_version 249
%global json_glib_version 1.6.0

# 1.9.3: test suite fails on ppc64le
%ifarch ppc64le
%def_without check
%endif

%def_with check

%def_enable tests
%def_enable flashrom

# fwupd-efi is only available on these arches
%ifarch x86_64 aarch64 loongarch64 riscv64
%def_enable uefi
%endif

%ifarch x86_64 %ix86
%def_enable msr
%endif

%define fwupd_pluginsdir %_libdir/fwupd-%version

Name: fwupd
Version: 2.0.12
Release: alt1

Summary: Firmware update daemon
License: LGPL-2.1+
Group: System/Configuration/Hardware
Url: https://github.com/fwupd/fwupd

Source0: %name-%version.tar
Source2: fwupd.watch
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-ubt

BuildRequires: bash-completion
BuildRequires: cmake
BuildRequires: git-core
BuildRequires: gi-docgen
BuildRequires: glib2-devel >= %glib2_version
BuildRequires: libappstream-glib-devel
BuildRequires: libmm-glib-devel
BuildRequires: libqmi-glib-devel
BuildRequires: libmbim-glib-devel
BuildRequires: libjson-glib-devel >= %json_glib_version
BuildRequires: libprotobuf-c-devel
BuildRequires: /usr/bin/protoc /usr/bin/protoc-gen-c
BuildRequires: libarchive-devel
BuildRequires: libcolord-devel
BuildRequires: liblzma-devel
BuildRequires: libcbor-devel
BuildRequires: libcurl-devel >= %libcurl_version
BuildRequires: libelf-devel
BuildRequires: libgnutls-devel
BuildRequires: libgpgme-devel
BuildRequires: libusb-devel >= %libusb_version
BuildRequires: libblkid-devel
BuildRequires: libjcat-devel >= %libjcat_version
BuildRequires: libpango-gir-devel
BuildRequires: libpolkit-devel
%if_enabled flashrom
BUildRequires: libflashrom-devel
%endif
BuildRequires: libdrm-devel
BuildRequires: libsoup-devel
BuildRequires: libsqlite3-devel
BuildRequires: libsystemd-devel >= %systemd_version
BuildRequires: libtpm2-tss-devel
BuildRequires: libudev-devel
BuildRequires: libumockdev-devel
BuildRequires: libuuid-devel
BuildRequires: libxmlb-devel >= %libxmlb_version
BuildRequires: meson
BuildRequires: python3-module-Pillow
BuildRequires: python3-module-pycairo
BuildRequires: python3-module-pygobject3
BuildRequires: python3-module-jinja2
BuildRequires: vala-tools
BuildRequires: gobject-introspection-devel
BuildRequires: /proc

# Build with passim starting from p11
# No passim in p10 due to old libsoup3.0 and glib2
%if "%(rpmvercmp '%ubt_id' 'M110')" >= "0"
BuildRequires: libpassim-devel
%endif

%if_enabled uefi
BuildRequires: libpango-devel
BuildRequires: libcairo-devel libcairo-gobject-devel
BuildRequires: libfreetype-devel
BuildRequires: fontconfig
BuildRequires: fonts-ttf-dejavu
BuildRequires: gnu-efi
Requires: fwupd-efi
Provides: fwupdate
Obsoletes: fwupdate
%endif

%if_with check
BuildRequires: polkit
%endif

Requires: bubblewrap
Requires: libgusb >= 0.3.5

Obsoletes: fwupd-labels <= %EVR

%description
fwupd is a daemon to allow session software to update device firmware.

%package -n libfwupd%sover
Summary: Libraries for %name
Group: System/Libraries

%description -n libfwupd%sover
Libraries for %name.

%package -n libfwupd-devel
Summary: Development package for %name
Group: Development/C
Obsoletes: %name-devel < %EVR
Provides: %name-devel = %EVR

%description -n libfwupd-devel
Files for development with %name.

%package -n libfwupd-devel-docs
Summary: Documentation for libfwupd-devel
Group: Documentation
BuildArch: noarch

%description -n libfwupd-devel-docs
Documentation for libfwupd-devel.

%package tests
Group: System/Configuration/Hardware
Summary: Data files for installed tests

%description tests
Data files for installed tests.

%package plugin-modem-manager
Group: System/Configuration/Hardware
Summary: fwupd plugin using ModemManger
Requires: %name = %EVR

%description plugin-modem-manager
This provides the optional package which is only required on hardware that
might have mobile broadband hardware. It is probably not required on servers.

%prep
%setup
%patch0 -p1

%build
%meson \
    -Ddocs=enabled \
    --debug \
    -Dfirmware-packager=true \
    -Dman=true \
    -Dlvfs=true \
    -Dsupported_build=enabled \
%if_enabled flashrom
    -Dplugin_flashrom=enabled \
%else
    -Dplugin_flashrom=disabled \
%endif
%if_enabled tests
    -Dtests=true \
%else
    -Dtests=false \
%endif
    -Dplugin_modem_manager=enabled \
    -Dbluez=enabled

%meson_build

%install
%meson_install

# CET is available only since i686
%ifarch i386 i486 i586
rm -f %buildroot%_libexecdir/fwupd/fwupd-detect-cet ||:
%endif

mkdir -p --mode=0700 %buildroot%_localstatedir/fwupd/gnupg
mv %buildroot%_docdir/fwupd %buildroot%_docdir/fwupd-devel-%version
rm -f %buildroot%_docdir/%name-devel-%version/lib*
mv %buildroot%_docdir/libfw* %buildroot%_docdir/fwupd-devel-%version/

# Install docs/hsi.html to satisfy noarch check (non-identical noarch packages)
[ -f %buildroot%_docdir/fwupd-devel-%version/hsi.html ] || \
    install -Dpm0644 docs/hsi.html -t %buildroot%_docdir/fwupd-devel-%version/

%find_lang %name

%check
%meson_test

%files -f %name.lang
%doc README.md COPYING
%_man1dir/fwupdtool.1*
%_man1dir/fwupdmgr.1*
%_man1dir/dbxtool.1*
%_man5dir/*
%_man8dir/*
%config(noreplace)%_sysconfdir/fwupd/fwupd.conf
%dir %_libexecdir/fwupd
%_libexecdir/fwupd/fwupd
%_bindir/fwupdtool
%ifarch x86_64
%_libexecdir/fwupd/fwupd-detect-cet
%endif
%_datadir/bash-completion/completions/*
%_datadir/fish/vendor_completions.d/fwupdmgr.fish
%_iconsdir/hicolor/*/apps/org.freedesktop.fwupd.*
%_bindir/dbxtool
%_bindir/fwupdmgr
%dir %_sysconfdir/fwupd
%dir %_sysconfdir/fwupd/remotes.d
%_sysconfdir/fwupd/bios-settings.d
%config(noreplace)%_sysconfdir/fwupd/remotes.d/*.conf
%_sysconfdir/pki/fwupd
%_sysconfdir/pki/fwupd-metadata
%dir %_datadir/fwupd
%dir %_datadir/fwupd/metainfo
%dir %_datadir/fwupd/remotes.d
%dir %_datadir/fwupd/remotes.d/vendor
%_datadir/dbus-1/system.d/org.freedesktop.fwupd.conf
%_datadir/fwupd/remotes.d/vendor/firmware
%_datadir/dbus-1/interfaces/org.freedesktop.fwupd.xml
%_datadir/polkit-1/actions/org.freedesktop.fwupd.policy
%_datadir/polkit-1/rules.d/org.freedesktop.fwupd.rules
%_datadir/dbus-1/system-services/org.freedesktop.fwupd.service
%_datadir/metainfo/org.freedesktop.fwupd.metainfo.xml
%_datadir/fwupd/metainfo/org.freedesktop.fwupd.remotes.lvfs-testing.metainfo.xml
%_datadir/fwupd/metainfo/org.freedesktop.fwupd.remotes.lvfs.metainfo.xml
%_datadir/fwupd/firmware_packager.py
%_datadir/fwupd/add_capsule_header.py
%_datadir/fwupd/install_dell_bios_exe.py
%_datadir/fwupd/simple_client.py
%_unitdir/fwupd.service
%_unitdir/fwupd-refresh.timer
%_unitdir/fwupd-refresh.service
%_systemddir/system-shutdown/fwupd.shutdown
%dir %_localstatedir/fwupd
%dir %_datadir/fwupd/quirks.d
%_datadir/fwupd/quirks.d/builtin.quirk.gz
%_libdir/girepository-1.0/Fwupd-2.0.typelib
%dir %fwupd_pluginsdir
%fwupd_pluginsdir/libfwupd*.so
%_modulesloaddir/fwupd-i2c.conf
%if_enabled flashrom
%fwupd_pluginsdir/libfu_plugin_flashrom.so
%endif
%if_enabled msr
%_modulesloaddir/fwupd-msr.conf
%endif
%if_enabled uefi
%config(noreplace)%_sysconfdir/grub.d/35_fwupd
%_datadir/fwupd/uefi-capsule-ux.tar.xz
%endif
%_sysusersdir/fwupd.conf

%ghost %_localstatedir/fwupd/gnupg

%files -n libfwupd%sover
%_libdir/libfwupd.so.%{sover}*

%files plugin-modem-manager
%fwupd_pluginsdir/libfu_plugin_modem_manager.so

%files -n libfwupd-devel
%_datadir/dbus-1/interfaces/org.freedesktop.fwupd.xml
%_datadir/gir-1.0/Fwupd-2.0.gir
%_includedir/fwupd-3
%_libdir/libfwupd.so
%_libdir/pkgconfig/fwupd.pc
%_datadir/vala/vapi/*

%files -n libfwupd-devel-docs
%_docdir/fwupd-devel-%version

%files tests
%if_enabled tests
%dir %_datadir/fwupd/host-emulate.d
%_datadir/fwupd/host-emulate.d/*.json.gz
%_datadir/installed-tests/fwupd
%_libexecdir/installed-tests/fwupd
%_datadir/fwupd/remotes.d/fwupd-tests.conf
%endif

%changelog
