%define _unpackaged_files_terminate_build 1
%global optflags_lto %optflags_lto -ffat-lto-objects

Name: fuse
Version: 2.9.9
Release: alt5

Summary: a tool for creating virtual filesystems
License: GPLv2
Group: System/Kernel and hardware

Url: https://github.com/libfuse/

Source: %name-%version.tar
Source1: fuserumount2
Source2: alternatives

Patch: %name-%version.patch

BuildRequires(pre): rpm-macros-alternatives

Requires: mount >= 2.11
Provides: avfs-fuse = %version
Obsoletes: avfs-fuse < %version
Requires(pre): fuse-common >= 1.1.3
Conflicts: fuse3 < 3.16.2-alt2

%description
FUSE (Filesystem in USErspace), an excellent tool
for creating custom filesystems with minimal effort
as well as for using them.

%package -n lib%name
License: LGPLv2
Group: System/Kernel and hardware
Summary: tool for creating virtual filesystems
Provides: FUSE = %version avfs-fuse = %version libavfs-fuse = %version
Obsoletes: FUSE < %version avfs-fuse < %version libavfs-fuse < %version

%description -n lib%name
FUSE (Filesystem in USErspace), an excellent tool
for creating custom filesystems with minimal effort.

This package contains shared libraries.

%package -n lib%name-devel
License: LGPLv2
Group: System/Kernel and hardware
Summary: tool for creating virtual filesystems
Requires: lib%name = %version-%release
Provides: libavfs-fuse-devel = %version
Obsoletes: libavfs-fuse-devel < %version

%description -n lib%name-devel
FUSE (Filesystem in USErspace), an excellent tool
for creating custom filesystems with minimal effort.

This package contains development headers.

%prep
%setup
%patch -p1

%build
mkdir -p m4
cp /usr/share/gettext/config.rpath ./config.rpath
%autoreconf
%configure \
	--enable-lib \
	--enable-util \
	--disable-static
%make_build

%install
%makeinstall_std

mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/lib%name.so.* %buildroot/%_lib/
ln -sf ../../%_lib/lib%name.so.%version %buildroot%_libdir/lib%name.so

rm -f %buildroot%_sysconfdir/udev/rules.d/*

mv %buildroot%_bindir/fusermount %buildroot%_bindir/fusermount2
install -pD %SOURCE1 %buildroot%_bindir/fuserumount2
install -pD %SOURCE2 %buildroot%_altdir/fuse2
rm -f %buildroot/etc/init.d/fuse

%pre
if [ $1 -ge 2 -o -e %_bindir/fusermount3 ]; then
    %_sbindir/control-dump fusermount
fi

%post
if [ $1 -ge 2 -o -e %_bindir/fusermount3 ]; then
    %_sbindir/control-restore fusermount
else
    %_sbindir/control fusermount fuseonly
fi

%files
%doc AUTHORS NEWS README.md README.NFS doc/how-fuse-works doc/kernel.txt
/sbin/mount.fuse
%attr(4710,root,fuse) %_bindir/fusermount2
%_bindir/ulockmgr_server
%attr(0755,root,root) %_bindir/fuserumount2
%_man1dir/*
%_man8dir/*
%_altdir/fuse2

%files -n lib%name
/%_lib/lib%name.so.*
%_libdir/lib*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%changelog
