Group: System/Libraries
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global minorver 1

Name:		ftplib
Version:	4.0
Release:	alt1_24
Summary:	Library of FTP routines
License:	LGPLv2+
URL:		http://nbpfaus.net/~pfau/ftplib-4/
Source0:	http://nbpfaus.net/~pfau/ftplib-4/%{name}-%{version}-%{minorver}.tar.gz
Patch0:		ftplib-3.1-1-modernize.patch
BuildRequires:	gcc
Source44: import.info

%description
ftplib is a set of routines that implement the FTP protocol. They allow 
applications to create and access remote files through function calls 
instead of needing to fork and exec an interactive ftp client program.

%package devel
Group: Development/Other
Summary:	Development files for ftplib
Requires:	ftplib = %{version}-%{release}

%description devel
Development libraries and headers for ftplib.

%package -n qftp
Group: Networking/WWW
Summary:	Simple ftp client application
# Automatically converted from old format: GPLv2+ - review is highly recommended.
License:	GPL-2.0-or-later

%description -n qftp
Command line driven ftp file transfer program using ftplib.

%prep
%setup -q -n %{name}-%{version}-%{minorver}
%patch0  -p1 -b .modern

%build
cd src/
%make_build DEBUG="$RPM_OPT_FLAGS"

%install
mkdir $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_libdir}
mkdir -p $RPM_BUILD_ROOT%{_includedir}
cd src/
make DESTDIR=$RPM_BUILD_ROOT LIBDIR="%{_libdir}" install

cd ${RPM_BUILD_ROOT}%{_libdir}
chmod +x libftp.so.4.0
ln -sf libftp.so.4.0 libftp.so.4
ln -sf libftp.so.4 libftp.so

cd ${RPM_BUILD_ROOT}%{_bindir}
for f in ftpdir ftpget ftplist ftprm ftpsend; do
	ln -s qftp $f
done



%files
%doc CHANGES
%doc --no-dereference LICENSE
%{_libdir}/libftp*.so.*

%files devel
%doc additional_rfcs README.ftplib* RFC959.txt html/
%{_includedir}/ftplib.h
%{_libdir}/libftp*.so

%files -n qftp
%doc README.qftp
%{_bindir}/ftpdir
%{_bindir}/ftpget
%{_bindir}/ftplist
%{_bindir}/ftprm
%{_bindir}/ftpsend
%{_bindir}/qftp

%changelog
