# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(File/ShareDir.pm) perl(File/Slurp.pm) perl(File/Which.pm) perl(Locale/Maketext/Simple.pm) perl(Math/Trig.pm)
# END SourceDeps(oneline)
Name: frozen-bubble
Version: 2.212
Release: alt2

Summary(ru_RU.UTF-8): игра Frozen Bubble
Summary: Frozen Bubble arcade game
License: GPL
Group: Games/Arcade

Url: http://www.frozen-bubble.org/
Source: %name-%version.tar
Source2: fb-server.service
Patch0:	frozen-bubble-2.2.1-setuid.patch
Patch1:	0001-Fix-buffer-size-when-formatting-current-date.patch

Requires: %name-data = %version

#BuildRequires: perl-Math-Complex

BuildRequires:	perl(Alien/SDL.pm)
BuildRequires:	perl(Archive/Extract.pm)
BuildRequires:	perl(autodie.pm)
BuildRequires:	perl(Compress/Bzip2.pm)
BuildRequires:	perl(IPC/System/Simple.pm)
BuildRequires:	perl(Locale/Maketext/Extract.pm)
BuildRequires:	perl(parent.pm)
BuildRequires:	perl-SDL
BuildRequires:	perl-devel
BuildRequires:	pkgconfig(SDL_image)
BuildRequires:	pkgconfig(SDL_mixer) >= 1.2.2
BuildRequires:	pkgconfig(SDL_Pango)
BuildRequires:	libsmpeg-devel

# due to conflict perl-SDL <-> perl-SDL_Perl
%filter_from_requires /^perl(SDL/d
Requires:	perl-SDL


%description
Colorful 3D rendered penguin animations, 100 levels of 1p game,
hours and hours of 2p game, nights and nights of 2p/3p/4p/5p game
over LAN or Internet, a level-editor, 3 professional quality
digital soundtracks, 15 stereo sound effects, 8 unique graphical
transition effects, 8 unique logo eye-candies.

%description -l ru_RU.UTF-8
Цветные мультяшные пингвины, 100 уровней однопользовательской игры,
многие часы игры вдвоём, долгие ночи двух-пятипользовательской игры
по локальной сети или через интернет, редактор уровней, три дорожки
звукового сопровождения профессионального качества, 15 стереоэффектов,
8 уникальных эффектов графического перехода и 8 просто красивостей.

%package data
Summary: Frozen Bubble arcade game
Group: Games/Arcade
Conflicts: %name < %version
BuildArch: noarch

%description data
Colorful 3D rendered penguin animations, 100 levels of 1p game,
hours and hours of 2p game, nights and nights of 2p/3p/4p/5p game
over LAN or Internet, a level-editor, 3 professional quality
digital soundtracks, 15 stereo sound effects, 8 unique graphical
transition effects, 8 unique logo eye-candies.

%description -l ru_RU.UTF-8
Данные для игры Frozen Bubble.

%package server
Group: Games/Arcade
Summary: Frozen Bubble network game dedicated server
BuildRequires: libsystemd-devel libudev-devel

%description server
Frozen Bubble network game dedicated server. The server is already included
with the game in order to be launched automatically for LAN games, so you
only need to install this package if you want to run a fully dedicated
Frozen Bubble network game server.

%prep
%setup
%patch1 -p1

# -------- from fedora -----------------------------------------------
# Rename this README since the main server README has the same name
mv server/init/README server/README.init
# Change the example server configuration file to be a working one, which only
# launches a LAN server and doesn't try to register itself on the Internet
sed -ie "s#^a .*#z\nq\nL#" server/init/fb-server.conf
# -------- from fedora -----------------------------------------------


%build
export CFLAGS="%{optflags} -Wno-error=unused-result"
%perl_vendor_build

%install
%perl_vendor_install

mkdir -p %buildroot%_desktopdir
cat <<EOF >%buildroot%_desktopdir/%name.desktop
[Desktop Entry]
Type=Application
Name=Frozen Bubble
Comment=Frozen Bubble Arcade Game
Comment[ru]=Игра Frozen Bubble
TryExec=%name
Exec=%name
Icon=%name
Categories=Game;ArcadeGame;
Terminal=false
StartupNotify=false
EOF

install -pDm644 share/icons/%name-icon-16x16.png %buildroot%_miconsdir/%name.png
install -pDm644 share/icons/%name-icon-32x32.png %buildroot%_niconsdir/%name.png
install -pDm644 share/icons/%name-icon-48x48.png %buildroot%_liconsdir/%name.png

rm -rf %buildroot%perl_vendor_autolib/share/dist/Games-FrozenBubble/icons
mv %buildroot%perl_vendor_autolib/share/dist/Games-FrozenBubble %buildroot%_datadir/%name
ln -s `relative %_datadir/%name %perl_vendor_autolib/share/dist/Games-FrozenBubble` \
   %buildroot%perl_vendor_autolib/share/dist/Games-FrozenBubble


# -------- from fedora -----------------------------------------------
# Install server init script and default configuration
install -D -p -m 0644 %{SOURCE2} \
    %{buildroot}%{_unitdir}/fb-server.service
install -D -p -m 0644 server/init/fb-server.conf \
    %{buildroot}%{_sysconfdir}/fb-server.conf

# Register as an application to be visible in the software center
#
# NOTE: It would be *awesome* if this file was maintained by the upstream
# project, translated and installed into the right place during `make install`.
#
# See http://www.freedesktop.org/software/appstream/docs/ for more details.
#
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
cat > $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright 2014 Richard Hughes <richard@hughsie.com> -->
<!--
EmailAddress: contact2@frozen-bubble.org
SentUpstream: 2014-09-17
-->
<application>
  <id type="desktop">frozen-bubble.desktop</id>
  <metadata_license>CC0-1.0</metadata_license>
  <summary>An addictive game about frozen bubbles</summary>
  <description>
    <p>
      Frozen Bubble is a free and open source game in which you throw colorful
      bubbles and build groups to destroy them.
    </p>
    <p>
      You can play this game locally or over the Internet.
      It also contains a level editor for you to create your own games.
    </p>
  </description>
  <url type="homepage">http://www.frozen-bubble.org/</url>
  <screenshots>
    <screenshot type="default">https://www.filepicker.io/api/file/zfCHFlCsR4OnStuPBwmQ</screenshot>
    <screenshot>http://blog.kii.com/wp-content/uploads/2013/06/frozenbubble.jpg</screenshot>
    <screenshot>https://www.filepicker.io/api/file/eqPdEWZMTtS1Un1LoRQ0</screenshot>
  </screenshots>
  <updatecontact>contact2_at_frozen-bubble.org</updatecontact>
</application>
EOF
# -------- from fedora -----------------------------------------------

%post server
/usr/sbin/useradd -r -s /sbin/nologin -d %{_datadir}/%{name} fbubble \
    &>/dev/null || :
%post_service fb-server

%preun server
%preun_service fb-server

%files
%perl_vendor_archlib/G*
%perl_vendor_autolib/G*
%perl_vendor_autolib/share/dist/Games-FrozenBubble

%files data
%doc README AUTHORS HISTORY COPYING
%_bindir/%name
%_bindir/%name-editor
%_man1dir/%name.1*
%_man1dir/%name-editor.1*
%_desktopdir/%name.desktop
%_niconsdir/*.png
%_miconsdir/*.png
%_liconsdir/*.png
%{_datadir}/appdata/%{name}.appdata.xml
%dir %_datadir/%name
%_datadir/%name/data
%_datadir/%name/gfx
%_datadir/%name/snd
%_datadir/%name/locale

%files server
%doc server/AUTHORS server/README*
%doc COPYING
%config(noreplace) %{_sysconfdir}/fb-server.conf
%{_unitdir}/fb-server.service
%{_bindir}/fb-server

# TODO:
# - package server

%changelog
