%def_disable snapshot
%define ver_major 1.8
%def_enable video
%define xdg_name org.gnome.frogr

Name: frogr
Version: %ver_major.1
Release: alt1

Summary: A Flickr Remote Organizer for GNOME
License: GPL-3.0
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Frogr

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%{?_enable_video:Requires: gst-plugins-base1.0 gst-plugins-good1.0 gst-plugins-bad1.0 gst-libav}

%define gtk_ver 3.16.0
%define json_glib_ver 1.2

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson yelp-tools libappstream-glib-devel
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: pkgconfig(libsoup-3.0) libexif-devel libxml2-devel libgcrypt-devel
%{?_enable_video:BuildRequires: gstreamer1.0-devel}

%description
Frogr intends to be a complete GNOME application to remotely manage
a flickr account from the desktop.

%prep
%setup

%build
%meson %{?_enable_video:-Denable-video=true}
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*x*/apps/%xdg_name.png
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_iconsdir/hicolor/scalable/apps/%xdg_name-symbolic.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%_man1dir/%name.1.*
%doc AUTHORS NEWS README


%changelog
