Name: fritzing
Version: 1.0.5
Release: alt2

Summary: Intuitive EDA platform featuring from prototype to product
License: GPLv2 and GPLv3 and CC-BY-SA-3.0
Group: Engineering

Url: http://fritzing.org
# https://github.com/fritzing/fritzing-app
Source0: %name-%version.tar
# https://github.com/fritzing/fritzing-parts
Source1: %name-parts.tar
# Need to refresh at every update of fritzing-parts
# Execute Fritzing -db parts.db in fritzing-parts directory
# 1. Install new version of Fritzing and parts
# 2. cd /usr/share/fritzing/fritzing-parts
# 3. git init . ; git add . ; git commit
# 4. Fritzing . -db ~/parts.db
# 5. ???
# 6. PROFIT!!!
Source2: parts.db

Patch: fritzing-desktop-file-translation.patch

Patch1: 0003-maximum-qt-version.patch
Patch2: 0004-Work-around-build-issues-with-Qt-6.9.patch
Patch3: 0010-quazip-detect.patch
Patch4: 0011-ngspice-detect.patch
Patch5: 0012-clipper1-detect.patch
Patch6: %name-%version-%release.patch


Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires: boost-devel-headers desktop-file-utils gcc-c++ glibc-devel-static
BuildRequires: rpm-build-python3 rpmbuild-helper-desktop zlib-devel
BuildRequires: rpmbuild-helper-sugar-activity ruby ruby-stdlibs qt6-tools
BuildRequires: libgit2-devel qt6-base-devel qt6-svg-devel qt6-serialport-devel
BuildRequires: quazip-qt6-devel
BuildRequires: ngspice-devel libpolyclipping-devel libsvgpp-devel chrpath

# large chunk of arch-independent data is better not duplicated
Requires: %name-data = %EVR

# ngspice
Requires: ngspice libngspice0

%description
Fritzing is an open-source initiative to support designers, artists,
researchers and hobbyists to take the step from physical prototyping
to actual product. It is in the spirit of Processing and Arduino which
allows users to document their Arduino and other electronic-based
prototypes, and to create a PCB layout for manufacturing.

%package data
Summary: Data files for %name
License: GPLv3
Group: Engineering
BuildArch: noarch

%description data
Fritzing is an open-source initiative to support designers, artists,
researchers and hobbyists to take the step from physical prototyping
to actual product. It is in the spirit of Processing and Arduino which
allows users to document their Arduino and other electronic-based
prototypes, and to create a PCB layout for manufacturing.

This package contains shared data files for Fritzing.

%prep
%setup -a1

%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

rm -v sketches/core/Fritzing\ Creator\ Kit\ DE+EN/creator-kit-*/Fritzing/TwitterSaurus.fzz
rm -rv sketches/core/Fritzing\ Creator\ Kit\ DE+EN/creator-kit-*/Processing/TwitterSaurus*
rm -v sketches/core/obsolete/TwitterSaurus.fzz

# rebuild russian translation
lrelease-qt6 phoenix.pro

%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -name '*.cpp' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
qmake-qt6
%make_build debug

%install
%makeinstall_std INSTALL_ROOT=%buildroot debug-install

cp -r %name-parts %buildroot/%_datadir/%name
install -m0644 %SOURCE2 "%buildroot/%_datadir/%name/%name-parts/parts.db"

# A few files in /usr/share/fritzing end up executable.
find %{buildroot}%{_datadir}/%{name} -type f -exec chmod 644 '{}' ';'
find %{buildroot}%{_datadir}/%{name} -type d -exec chmod 755 '{}' ';'

chrpath -d %buildroot%_bindir/Fritzing

%check
if [[ "$(find %buildroot%_datadir/%name -name 'TwitterSaurus*' -o -name 'twitter4j*' | wc -l)" -gt 0 ]]; then
  echo "Found TwitterSaurus / twitter4j files - these should NOT be included in the final package" >&2
  exit 1
fi

%files
%doc LICENSE.*
%_bindir/Fritzing
%_pixmapsdir/%name.png
%_desktopdir/org.fritzing.Fritzing.desktop
%_datadir/metainfo/org.fritzing.Fritzing.appdata.xml
%_man1dir/Fritzing.*
%_datadir/mime/packages/%name.xml
%_datadir/metainfo

%files data
%_datadir/%name

%changelog
