# vim: set ft=spec: -*- rpm-spec -*-

# TODO:  soname change - split libfreeipmi
%define freeipmi_soname 17
%define ipmiconsole_soname 2
%define ipmidetect_soname 0
%define ipmimonitoring_soname 6

%define docdir %_defaultdocdir/%name-%version

Name: freeipmi
Version: 1.6.16
Release: alt1

Summary: GNU FreeIPMI - Intelligent Platform Management System
Group: Monitoring
License: GPLv3
Url: https://www.gnu.org/software/freeipmi/
VCS: https://git.savannah.gnu.org/git/freeipmi.git

PreReq: lib%name = %EVR

Source: %name-%version.tar
Source1: %name.watch
Patch: %name-%version-%release.patch

BuildRequires: libgcrypt-devel texinfo

%description
This project provides "Remote-Console" (out-of-band) and
"System Management Software" (in-band) based on Intelligent
Platform Management Interface (IPMI v1.5/2.0) specification.

%package -n lib%name
Summary: FreeIPMI shared libraries
Group: System/Libraries

%description -n lib%name
FreeIPMI shared libraries.

%package -n lib%name-devel
Summary: GNU FreeIPMI development files
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
GNU FreeIPMI development files.

%package bmc-watchdog
Summary: GNU FreeIPMI BMC watchdog
Group: Monitoring
PreReq: lib%name = %version-%release

%description bmc-watchdog
Watchdog daemon for OS monitoring and recovery.

%package ipmidetectd
Summary: GNU FreeIPMI Detection daemon
Group: Monitoring
PreReq: lib%name = %version-%release

%description ipmidetectd
The ipmidetectd daemon regularly ipmipings remote nodes.
The ipmidetect tool and library will determine detected vs. undetected
ipmi systems based on the most recent ipmipings received.

%package ipmiseld
Summary: FreeIPMI SEL syslog logging daemon
Group: Monitoring
PreReq: lib%name = %EVR

%description ipmiseld
IPMI SEL syslog logging daemon.

%package doc
Summary: GNU FreeIPMI documentation
Group: Documentation
Conflicts: lib%name < %EVR
Conflicts: lib%name > %EVR
BuildArch: noarch

%description doc
GNU FreeIPMI documentation.

%prep
%setup
%add_optflags -D_GNU_SOURCE
%patch -p1

%build
%autoreconf

%configure \
	--localstatedir=%_var \
	--with-systemdsystemunitdir=%_unitdir \
	--disable-static
%make_build

%install
%make_install DESTDIR=%buildroot \
	docdir=%docdir \
	install

find %buildroot%docdir/ -type f -size +4k \( -iname changelog\* -or -iname COPYING\* -or -iname \*ipmi\* \) -print0 |
xargs -r0 bzip2 -9f --

%post -n lib%name
touch %_localstatedir/%name/ipckey

%preun -n lib%name
[ "$1" -eq 0 ] && rm -f %_localstatedir/%name/ipckey ||: >/dev/null 2>&1

%post ipmidetectd
%post_service ipmidetectd

%preun ipmidetectd
%preun_service ipmidetectd

%post bmc-watchdog
%post_service bmc-watchdog

%preun bmc-watchdog
%preun_service bmc-watchdog

%post ipmiseld
%post_service bmc-watchdog

%preun ipmiseld
%preun_service bmc-watchdog

%files
%_sbindir/*
%exclude %_sbindir/ipmiseld
%exclude %_sbindir/bmc-watchdog
%exclude %_sbindir/ipmidetectd
%_man8dir/*.8*
%exclude %_man8dir/ipmiseld.8*
%exclude %_man8dir/bmc-watchdog.8*
%exclude %_man8dir/*detectd*.8*
%_man5dir/*.5*
%exclude %_man5dir/*detectd*.5*
%exclude %_man5dir/*ipmiseld*.5*
%config %_sysconfdir/%name/freeipmi.conf
%config %_sysconfdir/%name/ipmidetect.conf
%config %_sysconfdir/%name/freeipmi_interpret_sel.conf
%config %_sysconfdir/%name/freeipmi_interpret_sensor.conf
%_man7dir/*.7*

%files -n lib%name
%_libdir/lib*.so.*
%_libdir/libfreeipmi.so.%{freeipmi_soname}
%_libdir/libfreeipmi.so.%{freeipmi_soname}.*
%_libdir/libipmiconsole.so.%ipmiconsole_soname
%_libdir/libipmiconsole.so.%ipmiconsole_soname.*
%_libdir/libipmidetect.so.%ipmidetect_soname
%_libdir/libipmidetect.so.%ipmidetect_soname.*
%_libdir/libipmimonitoring.so.%ipmimonitoring_soname
%_libdir/libipmimonitoring.so.%ipmimonitoring_soname.*
%dir %_sysconfdir/%name
%config %_sysconfdir/%name/libipmiconsole.conf
%dir %_localstatedir/%name
%ghost %_localstatedir/%name/ipckey

%files -n lib%name-devel
%_libdir/lib*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_man3dir/*

%files bmc-watchdog
%config(noreplace) %_sysconfdir/sysconfig/bmc-watchdog
%_unitdir/bmc-watchdog.service
%_sbindir/bmc-watchdog
%_man8dir/bmc-watchdog.8*

%files ipmidetectd
%_sbindir/ipmidetectd
%_unitdir/ipmidetectd.service
%_man5dir/*detectd*.5*
%_man8dir/*detectd*.8*
%config %_sysconfdir/%name/ipmidetectd.conf

%files ipmiseld
%_sbindir/ipmiseld
%_unitdir/ipmiseld.service
%_man5dir/*ipmiseld*.5*
%_man8dir/ipmiseld*.8*
%config %_sysconfdir/%name/ipmiseld.conf

%files doc
%docdir
%_infodir/%name-faq.info*

%changelog
