%define origrelease 2
Name: freedup
Summary: Links substantially identical, duplicate files to save file system space
Version: 1.6
Release: alt1
License: GPL
Group: File tools
Packager: Ildar Mulyukov <ildar@altlinux.ru>

Source: http://freedup.org/freedup-%version-%origrelease-src.tar
#.bz2
Url: http://freedup.org/

# Automatically added by buildreq on Thu Jul 28 2011 (-bi)
# optimized out: elfutils
BuildRequires: fakeroot

%description
Freedup eliminates duplicate files by linking them, and thus reduces the amount
of used disk space within one or more file systems. By default, hardlinks are
used on a single device, symbolic links when the devices differ. A set of
options allows you to modify the methods of file comparison, the hash functions,
the linking behavior, and the reporting style. You may use batch or interactive
mode. Freedup usually only considers identical files, but when comparing audio
or graphics files, you may elect to ignore the tags. Multimedia files often are
a good target for deduplication.

%prep
%setup
rm -f *.o %name symharden

%build
make %name symharden \
	CFLAGS="%optflags -Wall -pedantic -D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64 -DFLAVOUR='' -std=gnu99"

%check
fakeroot make test

%install
mkdir -p %buildroot{/usr/bin,%_man1dir}
install -s -p -m 755 %name symharden %buildroot%_bindir/
install -p -m 644 %name.1 %buildroot%_man1dir/%name.1

%files
%_bindir/*
%doc TODO README README.SHA COPYING.SHA verify ChangeLog html
%_man1dir/%name.1*

%changelog
