%define _unpackaged_files_terminate_build 1
%add_python3_path %_libdir/freecad/Mod %_libdir/freecad/Ext/*
%add_python3_req_skip FreeCADGui FreeCAD
%ifnarch %qt6_qtwebengine_arches
%add_python3_req_skip PySide6.QtWebEngineCore PySide6.QtWebEngineWidgets
%endif
%add_findprov_skiplist %_libdir/freecad/Mod/* %_libdir/freecad/Ext/*
%def_with bundled_libs
%def_with bundled_pycxx
%def_with glvnd
%def_with ninja
%def_with pybind11
%def_with pyside

%define oname freecad
%define ldir %_libdir/%oname
%ifndef build_parallel_jobs
%define build_parallel_jobs 7
%endif
%define git_rev 2fcc5317fe
%define git_date 18.11.2024

Name:    freecad
Version: 1.0.2
Release: alt2
Epoch:   1
Summary: OpenSource 3D CAD modeller
License: LGPL-2.0+
Group:   Graphics
Url:     http://free-cad.sourceforge.net/
# VCS:   https://github.com/FreeCAD/FreeCAD
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Source1: freecad.1
Source2: submodules.tar

%if_without bundled_libs
Patch1: %name-remove-3rdParty.patch
%endif
Patch2: freecad-0.19.2-alt-boost-link.patch
Patch3: freecad-alt-fix-icon-name-in-menu.patch
Patch4: freecad-alt-python-modules-path.patch
Patch6: freecad-1.0.0-alt-version-check.patch
Patch8: 0001-Port-plugins-to-PySide6.QtWidgets.patch
# https://forum.freecad.org/viewtopic.php?p=812867#p812867
# https://bugzilla.altlinux.org/show_bug.cgi?id=54082
Patch9: freecad-1.0.0-upstream-findocc.patch
Patch10: freecad-1.0.0-alt-print-attributes.patch

Provides:  free-cad = %version-%release
Obsoletes: free-cad < %version-%release

ExcludeArch: %ix86 armh ppc64le

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-xdg
BuildRequires(pre): rpm-macros-qt6-webengine
%if_with ninja
BuildRequires(pre): rpm-build-ninja
%endif
BuildRequires(pre): rpm-build-python3
BuildRequires: qt6-base-devel
BuildRequires: qt6-assistant
BuildRequires: qt6-designer
BuildRequires: qt6-svg-devel
BuildRequires: qt6-tools-devel
%ifarch %qt6_qtwebengine_arches
BuildRequires: qt6-webengine-devel
%endif
%if_with pyside
BuildRequires: python3-module-pyside6
BuildRequires: python3-module-pyside6-devel
BuildRequires: python3-module-shiboken6-devel
BuildRequires: python3-module-pivy
%else
%filter_from_requires /python3(PySide2/d
%endif
%define qmake %qmake_qt6
%define qtbindir %_qt6_bindir
BuildRequires: python3-devel swig gcc-fortran chrpath
BuildRequires: boost-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-geometry-devel
BuildRequires: boost-polygon-devel
BuildRequires: boost-program_options-devel
BuildRequires: boost-python3-devel
BuildRequires: boost-signals-devel
BuildRequires: libcoin3d-devel
#BuildRequires: libSoQt-devel
BuildRequires: zlib-devel
BuildRequires: libopencv2-devel libxerces-c-devel gcc-c++
BuildRequires: java-devel-default
BuildRequires: libXxf86misc-devel
BuildRequires: opencascade-devel libgts-devel
BuildRequires: libode-devel libann-devel
BuildRequires: doxygen graphviz
BuildRequires: eigen3
BuildRequires: libnumpy-py3-devel
BuildRequires: boost-interprocess-devel
BuildRequires: gdb
BuildRequires: libvtk-devel vtk-examples vtk-python3
BuildRequires: libhdf5-devel
BuildRequires: libmed-devel libspnav-devel
#BuildRequires: python3-module-matplotlib-qt6
BuildRequires: libkdtree++-devel
%if_without bundled_libs
BuildRequires: libsmesh-devel libnetgen-devel netgen openmpi-devel
%endif
%if_with glvnd
BuildRequires: libglvnd-devel
%else
Requires: libEGL-devel libGLU-devel
%endif
#BuildRequires: texlive-extra-utils
BuildRequires: libnetgen-devel netgen
%if_with pybind11
BuildRequires: pybind11-devel
%endif
%if_without bundled_pycxx
BuildRequires: python3-module-pycxx-devel
%endif
# 1.0
BuildRequires: libyaml-cpp-devel
BuildRequires: python3-module-matplotlib
BuildRequires: libmicrosoft-gsl-devel
BuildRequires: libGL-devel
BuildRequires: openmpi-devel
BuildRequires: libfmt-devel

#%%py3_requires matplotlib.backends.backend_qt6
%py3_requires pivy
#add_python3_req_skip pyopencl IfcImport Units
%add_python3_req_skip Part PartDesign Sketcher
%add_findreq_skiplist %ldir/Mod/*

%ifnarch armh
# TODO: cgal needed for openscad was not built for armh
Requires: openscad
%endif
Requires: python3-module-pyside6-devel
Requires: python3-module-GitPython
Requires: netgen
Requires: libredwg

Provides:  free-cad-docs = %version-%release
Obsoletes: free-cad-docs < %version-%release
Provides:  freecad-docs = %version-%release
Obsoletes: freecad-docs < %version-%release

%description
FreeCAD will be a general purpose 3D CAD modeler. FreeCAD is aimed directly at
mechanical engineering and product design but also fits in a wider range of uses
around engineering, such as architecture or other engineering specialties.

FreeCAD features tools similar to Catia, SolidWorks or Solid Edge, and therefore
also falls into the category of MCAD, PLM, CAx and CAE. It will be a feature
based parametric modeler with a modular software architecture which makes it
easy to provide additional functionality without modifying the core system.

%package devel
Summary: Development files for FreeCAD
Group: Development/C++

%description devel
%summary

%prep
%setup
%if_without bundled_libs
# Removed bundled libraries
%patch1 -p1
rm -rf src/3rdParty
%else
tar xf %SOURCE2
%endif
%patch2 -p1
%patch3 -p1
%patch4 -p1
%if_without bundled_pycxx
rm -rf src/CXX
%endif
%patch6 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1

%ifarch %e2k
sed -i "/-fext-numeric-literals/d" src/Mod/CAM/App/CMakeLists.txt
# because "error: cpio archive too big"
%define optflags_debug -g0
# too much warnings of this type
%add_optflags -Wno-overloaded-virtual
sed -i "s/FC_OS_WIN32/__EDG__/" src/Mod/Sketcher/App/GeoEnum.{h,cpp}
sed -i "/extern template/{N;s/.*/#ifndef OBSERVER_CPP\n&\n#endif/}" src/Base/Observer.h
sed -i "1i #define OBSERVER_CPP" src/Base/Observer.cpp
%endif

%build
export PATH=$PATH:%_qt6_bindir
%add_optflags -Wl,--no-undefined
%add_optflags -Wl,-rpath,%ldir/lib
%if_with ninja
%cmake_insource -GNinja \
%else
%cmake_insource \
%endif
	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_CXX_FLAGS_RELEASE="-DNDEBUG" \
	-DCMAKE_INSTALL_DATADIR=%ldir \
	-DCMAKE_INSTALL_DOCDIR=%ldir/doc \
	-DCMAKE_INSTALL_LIBDIR=%ldir/lib \
	-DOPENMPI_INCLUDE_DIRS=%_libdir/openmpi/include \
	-DPYTHON_EXECUTABLE=%__python3 \
%if_with pybind11
    -DFREECAD_USE_PYBIND11=ON \
%endif
	-DFREECAD_LIBPACK_USEPYSIDE=OFF \
	-DBUILD_QT6=ON \
	-DFREECAD_QT_VERSION=6 \
%ifnarch %qt6_qtwebengine_arches
	-DBUILD_WEB=OFF \
%endif
%if_without bundled_libs
	-DFREECAD_USE_EXTERNAL_SMESH=ON \
	-DSMESH_DIR=%_libdir/cmake \
	-DSMESH_INCLUDE_DIR=%_includedir/smesh \
	-DBUILD_FEM_NETGEN=ON \
%endif
%if_with glvnd
	-DOpenGL_GL_PREFERENCE=GLVND \
%endif
	-DFREECAD_USE_EXTERNAL_PIVY=ON \
	-DPACKAGE_WCREF="%git_rev" \
	-DPACKAGE_WCDATE="%git_date" \
	-DPACKAGE_WCURL="https://github.com/FreeCAD/FreeCAD" \
    -DUSE_OPENCV=ON \
%if_without bundled_pycxx
    -DPYCXX_INCLUDE_DIR=$(pkg-config --variable=includedir PyCXX) \
    -DPYCXX_SOURCE_DIR=$(pkg-config --variable=srcdir PyCXX) \
%endif
	-Wno-dev \
	-DENABLE_DEVELOPER_TESTS=OFF
export NPROCS=%build_parallel_jobs
%if_with ninja
%ninja_build
%else
%make_build
%endif

%install
%if_with ninja
%ninja_install
%else
%makeinstall_std
%endif

# binaries
mkdir -p %buildroot%ldir/bin
mv %buildroot%_bindir/* %buildroot%ldir/bin
ln -s ../%_lib/%name/bin/FreeCAD %buildroot%_bindir/freecad
ln -s ../%_lib/%name/bin/FreeCADCmd %buildroot%_bindir/freecadcmd
ln -s ../%_lib/%name/bin/FreeCAD %buildroot%_bindir/FreeCAD
ln -s ../%_lib/%name/bin/FreeCADCmd %buildroot%_bindir/FreeCADCmd

# manpage
install -Dm0644 %SOURCE1 %buildroot%_man1dir/%name.1

# stuff
cp -af %buildroot%_prefix/Mod/* %buildroot%ldir/Mod
rm -rf %buildroot%_prefix/Mod
cp -af %buildroot%_prefix/Ext/ %buildroot%ldir/Ext
rm -rf %buildroot%_prefix/Ext

# l10n
%find_lang --with-kde %name

# fix python shebang
subst 's|#!.*python$|#!%__python3|' $(grep -Rl '#!.*python$' %buildroot%_libdir/freecad/Mod)

# fix import PySide6 python module
subst 's|PySide|&6|g' $(find %buildroot%_libdir/freecad -name \*.py) %buildroot%python3_sitelibdir/freecad/UiTools.py
subst 's|PySide66|PySide6|g' $(find %buildroot%_libdir/freecad -name \*.py)
subst 's|PySide6Uic|PySideUic|g' $(find %buildroot%_libdir/freecad -name \*.py)
subst 's|import PySide6 as PySide|import PySide6|g' $(find %buildroot%_libdir/freecad -name \*.py)

# remove static libraries
rm -f %buildroot%_libdir/freecad/lib/*.a

# remove header file
rm -f %buildroot%_includedir/E57Format/*.h
rm -rf %buildroot%_includedir/{gmock,gtest}

# remove buggy Tux mod
rm -rf %buildroot%ldir/Mod/Tux

%files -f %name.lang
%doc README.md SECURITY.md
%doc %ldir/doc
%dir %ldir
%_bindir/*
%ldir/bin
%ldir/lib
%ldir/Gui
%ldir/Ext
%ldir/Mod
%ldir/3Dconnexion
%ldir/examples
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/org.freecad.FreeCAD.png
%_iconsdir/hicolor/scalable/*/*.svg
%_man1dir/*
%_xdgdatadir/mime/packages/*
%_pixmapsdir/%name.xpm
%_datadir/metainfo/*.metainfo.xml
%_datadir/thumbnailers/FreeCAD.thumbnailer
%python3_sitelibdir/%name

%files devel
%_includedir/OndselSolver
%_datadir/pkgconfig/OndselSolver.pc

%changelog
