# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: fossology-nomos
Version: 4.5.0
Release: alt1
Summary: Nomos detects licenses and copyrights in a file
License: GPL-2.0-or-later
Group: Development/Other
Url: https://github.com/fossology/fossology

Provides: nomos
Provides: nomossa

Source: %name-%version.tar

BuildRequires: glib2-devel
BuildRequires: libjson-c-devel

%description
%summary.

This is only handy standalone nomos agent CLI, excluding other parts of full
FOSSology open source license compliance software system and toolkit.

%prep
%setup

%build
%ifarch x86_64
%add_optflags -fanalyzer -Werror
%endif
%add_optflags %(getconf LFS_CFLAGS)
make -C src/nomos/agent -f Makefile.nomossa.altlinux \
       CFLAGS='%optflags -DVERSION_S=\"%version\" -DCOMMIT_HASH_S=\"%release\"'

%install
install -Dm0755 -p src/nomos/agent/nomossa %buildroot%_bindir/nomossa

%check
PATH=%buildroot%_bindir:$PATH
nomossa -V | grep -Fx 'nomos build version: %version r(%release).'
cp -a LICENSE /tmp
pushd /tmp
  date > no_lice
  time nomossa LICENSE | grep -xF 'File LICENSE contains license(s) GPL-2.0-only,LGPL-2.1-only'
  time nomossa no_lice | grep -xF 'File no_lice contains license(s) No_license_found'
popd
# Crash test.
nomossa -d .gear
nomossa -d LICENSES

%files
%doc README.md LICENSE src/nomos/agent/README src/nomos/agent/Notes
%_bindir/nomossa

%changelog
