# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: forkstat
Version: 0.04.00
Release: alt1
Summary: Process fork/exec/exit monitoring tool
License: GPL-2.0-or-later
Group: Monitoring
Url: https://github.com/ColinIanKing/forkstat

Source: %name-%version.tar

%description
Forkstat is a program that logs process fork(), exec() and exit()
activity. It is useful for monitoring system behaviour and to track down
rogue processes that are spawning off processes and potentially abusing
the system.

Note that forkstat uses the Linux netlink connector to gather process
activity and this may miss events if the system is overly busy. Netlink
connector also requires root privilege.

%prep
%setup

%build
%ifarch x86_64
%add_optflags -fanalyzer -Werror
%endif
%add_optflags %(getconf LFS_CFLAGS)
export CFLAGS='%{optflags}'
%make_build

%install
%makeinstall_std

%files
%doc COPYING README.md
%_bindir/forkstat
%_man8dir/forkstat.*
%_datadir/bash-completion/completions/forkstat

%changelog
