%def_disable backportM4x_mode

Packager: Stanislav Ievlev <inger@altlinux.org>

Name: foomatic-db-engine
Version: 4.0.13
Release: alt1

Provides: foomatic-addon = %version
Obsoletes: foomatic-addon

PreReq: alternatives >= 0.3

Summary: Foomatic database access, printer admin, and printing utils
License: GPL
Group: Publishing

Url: http://www.linuxprinting.org

Source: http://www.linuxprinting.org/download/foomatic/%name-%version.tar
Source1: foomatic-db-engine.alternatives

Patch1: foomatic-db-engine-3.0.2-suse-A4.patch
Patch2:	foomatic-db-engine-4.0.12-alt-perl522.patch

%define _compress_method gzip

BuildPreReq: cups >= 1.2.1


# Automatically added by buildreq on Fri May 26 2006
BuildRequires: cups curl foomatic-filters ghostscript-classic libxml2-devel netcat perl-devel samba-client wget zlib-devel perl-Encode

%description
This package contains the tools for accessing the Foomatic database,
for printer administration, and for printing.

%prep
%setup -q -n %name-%version
%patch1 -p1
%patch2 -p2

%build
export SH=/bin/bash
export LIB_CUPS=%_libexecdir/cups
%configure
%make

%install
make \
    DESTDIR=%buildroot \
    PREFIX=%_prefix \
    INSTALLSITELIB=%perl_vendor_privlib \
    INSTALLSITEARCH=%perl_vendor_archlib \
    install

#cd lib
#_perl_vendor_install

install -d $RPM_BUILD_ROOT/var/cache/foomatic/pcache
install -d $RPM_BUILD_ROOT/var/cache/foomatic/compiled

( cd $RPM_BUILD_ROOT%_bindir
  ln -s foomatic-printjob lpr-foomatic
  ln -s foomatic-printjob lpq-foomatic
  ln -s foomatic-printjob lprm-foomatic
)
( cd $RPM_BUILD_ROOT%_sbindir
  ln -s %_bindir/foomatic-printjob lpc-foomatic
)

(cd $RPM_BUILD_ROOT%_man1dir
 ln -s foomatic-printjob.1.gz  lpr-foomatic.1.gz
 ln -s foomatic-printjob.1.gz  lpq-foomatic.1.gz
 ln -s foomatic-printjob.1.gz  lprm-foomatic.1.gz
)

( cd $RPM_BUILD_ROOT%_man8dir
  ln -s ../man1/foomatic-printjob.1.gz lpc-foomatic.8.gz
)

%__install -Dpm644 %SOURCE1 %buildroot%_altdir/%name

%if_enabled backportM4x_mode
%post
%register_alternatives %name -- lpr lpr.1.gz lpq lpq.1.gz lprm lprm.1.gz lpc lpc.1.gz

%preun
%unregister_alternatives %name
%endif

%files
%doc README USAGE ChangeLog
%_altdir/%name
%_cachedir/*
%_datadir/foomatic/templates
%_man1dir/*
%_man8dir/*
%_bindir/*
%_sbindir/*
%_libexecdir/cups/driver/foomatic
%perl_vendor_privlib/Foomatic*

%changelog
