
Name: fonts-ttf-jetbrains-mono
Version: 2.304
Release: alt1

License: OFL-1.1
Group: System/Fonts/True type
URL: https://github.com/JetBrains/JetBrainsMono

Summary: A mono-space font family containing coding ligatures

# Source-url: https://github.com/JetBrains/JetBrainsMono/archive/refs/tags/v%version.tar.gz
Source: %name-%version.tar

Source10: 60-jetbrains-mono-fonts.xml
Source11: 58-jetbrains-mono-nl-fonts.xml

BuildArch: noarch

BuildRequires(pre): rpm-macros-fonts rpm-build-intro
BuildRequires: rpm-build-fonts
BuildRequires: rpm-build-fedora-compat-fonts

%define common_description \
The JetBrains Mono project publishes developer-oriented font families.\
\
Their forms are simple and free from unnecessary details. Rendered in small\
sizes, the text looks crisper. The easier the forms, the faster the eye\
perceives them and the less effort the brain needs to process them.\
\
The shape of ovals approaches that of rectangular symbols. This makes the whole\
pattern of the text more clear-N.ut. The outer sides of ovals ensure there are\
no additional obstacles for your eyes as they scan the text vertically.\
\
Characters remain standard in width, but the height of the lowercase is\
maximized. This approach keeps code lines to the length that developers expect,\
and it helps improve rendering since each letter occupies more pixels.\
\
They use a 9A. italic angle; this maintains the optimal contrast to minimize\
distraction and eye strain. The usual angle is about 11A.a..12A..


%description
%{common_description}


%package -n fonts-otf-jetbrains-mono
Group: System/Fonts/True type
Summary: A mono-space coding font family


%description -n fonts-otf-jetbrains-mono
%{common_description}

The first font family published by the project, JetBrains Mono, includes coding
ligatures. They will enhance the rendering of source code but may be
problematic for other use cases.


%package -n fonts-ttf-jetbrains-mono-nl
Group: System/Fonts/True type
Summary: A mono-space coding font family


%description -n fonts-ttf-jetbrains-mono-nl
%{common_description}

The second font family published by the project, JetBrains Mono NL, is general
purpose and free of coding ligatures.

%prep
%setup

%build
# fontbuild 0
fontnames=$(
  for font in 'fonts/otf/JetBrainsMono-Bold.otf' 'fonts/otf/JetBrainsMono-BoldItalic.otf' 'fonts/otf/JetBrainsMono-ExtraBold.otf' 'fonts/otf/JetBrainsMono-ExtraBoldItalic.otf' 'fonts/otf/JetBrainsMono-ExtraLight.otf' 'fonts/otf/JetBrainsMono-ExtraLightItalic.otf' 'fonts/otf/JetBrainsMono-Italic.otf' 'fonts/otf/JetBrainsMono-Light.otf' 'fonts/otf/JetBrainsMono-LightItalic.otf' 'fonts/otf/JetBrainsMono-Medium.otf' 'fonts/otf/JetBrainsMono-MediumItalic.otf' 'fonts/otf/JetBrainsMono-Regular.otf' 'fonts/otf/JetBrainsMono-SemiBold.otf' 'fonts/otf/JetBrainsMono-SemiBoldItalic.otf' 'fonts/otf/JetBrainsMono-Thin.otf' 'fonts/otf/JetBrainsMono-ThinItalic.otf'; do
    fc-scan "${font}" -f "    <font>%%{fullname[0]}</font>\n"
  done | sort -u
)
if [[ -n "${fontnames}" ]] ; then
  fontnames=$'\n'"  <provides>"$'\n'"${fontnames}"$'\n'"  </provides>"
fi
fontlangs=$(
  for font in 'fonts/otf/JetBrainsMono-Bold.otf' 'fonts/otf/JetBrainsMono-BoldItalic.otf' 'fonts/otf/JetBrainsMono-ExtraBold.otf' 'fonts/otf/JetBrainsMono-ExtraBoldItalic.otf' 'fonts/otf/JetBrainsMono-ExtraLight.otf' 'fonts/otf/JetBrainsMono-ExtraLightItalic.otf' 'fonts/otf/JetBrainsMono-Italic.otf' 'fonts/otf/JetBrainsMono-Light.otf' 'fonts/otf/JetBrainsMono-LightItalic.otf' 'fonts/otf/JetBrainsMono-Medium.otf' 'fonts/otf/JetBrainsMono-MediumItalic.otf' 'fonts/otf/JetBrainsMono-Regular.otf' 'fonts/otf/JetBrainsMono-SemiBold.otf' 'fonts/otf/JetBrainsMono-SemiBoldItalic.otf' 'fonts/otf/JetBrainsMono-Thin.otf' 'fonts/otf/JetBrainsMono-ThinItalic.otf'; do
    fc-scan "${font}" -f "%%{[]lang{    <lang>%%{lang}</lang>\n}}"
  done | sort -u
)
if [[ -n "${fontlangs}" ]] ; then
  fontlangs=$'\n'"  <languages>"$'\n'"${fontlangs}"$'\n'"  </languages>"
fi

echo "Generating the jetbrains-mono-fonts appstream file"
cat > "org.altlinux.jetbrains-mono-fonts.metainfo.xml" << EOF_APPSTREAM
<?xml version="1.0" encoding="UTF-8"?>
<!-- SPDX-License-Identifier: MIT -->
<component type="font">
  <id>org.altlinux.jetbrains-mono-fonts</id>
  <metadata_license>MIT</metadata_license>
  <project_license>OFL 1.1</project_license>
  <name>JetBrains JetBrains Mono</name>
  <summary><![CDATA[A mono-space font family containing coding ligatures]]></summary>
  <description>
    <p><![CDATA[The JetBrains Mono project publishes developer-oriented font families.]]></p> Their forms are simple and free from unnecessary details. Rendered in small sizes, the text looks crisper. The easier the forms, the faster the eye perceives them and the less effort the brain needs to process them. The shape of ovals approaches that of rectangular symbols. This makes the whole pattern of the text more clear-сut. The outer sides of ovals ensure there are no additional obstacles for your eyes as they scan the text vertically. Characters remain standard in width, but the height of the lowercase is maximized. This approach keeps code lines to the length that developers expect, and it helps improve rendering since each letter occupies more pixels. They use a 9° italic angle; this maintains the optimal contrast to minimize distraction and eye strain. The usual angle is about 11°–12°. The first font family published by the project, JetBrains Mono, includes coding ligatures. They will enhance the rendering of source code but may be problematic for other use cases.
  </description>
  <updatecontact>devel@lists.altlinux.org</updatecontact>
  <url type="homepage">https://jetbrains.com/mono/</url>
  <releases>
    <release version="%{version}-%{release}" date="$(date -d @$SOURCE_DATE_EPOCH -u --rfc-3339=d)"/>
  </releases>${fontnames}${fontlangs}
</component>
EOF_APPSTREAM

# fontbuild 1
fontnames=$(
  for font in 'fonts/ttf/JetBrainsMonoNL-Bold.ttf' 'fonts/ttf/JetBrainsMonoNL-BoldItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraBold.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraBoldItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraLight.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraLightItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Italic.ttf' 'fonts/ttf/JetBrainsMonoNL-Light.ttf' 'fonts/ttf/JetBrainsMonoNL-LightItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Medium.ttf' 'fonts/ttf/JetBrainsMonoNL-MediumItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Regular.ttf' 'fonts/ttf/JetBrainsMonoNL-SemiBold.ttf' 'fonts/ttf/JetBrainsMonoNL-SemiBoldItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Thin.ttf' 'fonts/ttf/JetBrainsMonoNL-ThinItalic.ttf'; do
    fc-scan "${font}" -f "    <font>%%{fullname[0]}</font>\n"
  done | sort -u
)
if [[ -n "${fontnames}" ]] ; then
  fontnames=$'\n'"  <provides>"$'\n'"${fontnames}"$'\n'"  </provides>"
fi
fontlangs=$(
  for font in 'fonts/ttf/JetBrainsMonoNL-Bold.ttf' 'fonts/ttf/JetBrainsMonoNL-BoldItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraBold.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraBoldItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraLight.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraLightItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Italic.ttf' 'fonts/ttf/JetBrainsMonoNL-Light.ttf' 'fonts/ttf/JetBrainsMonoNL-LightItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Medium.ttf' 'fonts/ttf/JetBrainsMonoNL-MediumItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Regular.ttf' 'fonts/ttf/JetBrainsMonoNL-SemiBold.ttf' 'fonts/ttf/JetBrainsMonoNL-SemiBoldItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Thin.ttf' 'fonts/ttf/JetBrainsMonoNL-ThinItalic.ttf'; do
    fc-scan "${font}" -f "%%{[]lang{    <lang>%%{lang}</lang>\n}}"
  done | sort -u
)
if [[ -n "${fontlangs}" ]] ; then
  fontlangs=$'\n'"  <languages>"$'\n'"${fontlangs}"$'\n'"  </languages>"
fi

echo "Generating the jetbrains-mono-nl-fonts appstream file"
cat > "org.altlinux.jetbrains-mono-nl-fonts.metainfo.xml" << EOF_APPSTREAM
<?xml version="1.0" encoding="UTF-8"?>
<!-- SPDX-License-Identifier: MIT -->
<component type="font">
  <id>org.altlinux.jetbrains-mono-nl-fonts</id>
  <metadata_license>MIT</metadata_license>
  <project_license>OFL 1.1</project_license>
  <name>JetBrains JetBrains Mono NL</name>
  <summary><![CDATA[A mono-space coding font family]]></summary>
  <description>
    <p><![CDATA[The JetBrains Mono project publishes developer-oriented font families.]]></p> Their forms are simple and free from unnecessary details. Rendered in small sizes, the text looks crisper. The easier the forms, the faster the eye perceives them and the less effort the brain needs to process them. The shape of ovals approaches that of rectangular symbols. This makes the whole pattern of the text more clear-сut. The outer sides of ovals ensure there are no additional obstacles for your eyes as they scan the text vertically. Characters remain standard in width, but the height of the lowercase is maximized. This approach keeps code lines to the length that developers expect, and it helps improve rendering since each letter occupies more pixels. They use a 9° italic angle; this maintains the optimal contrast to minimize distraction and eye strain. The usual angle is about 11°–12°. The second font family published by the project, JetBrains Mono NL, is general purpose and free of coding ligatures.
  </description>
  <updatecontact>devel@lists.altlinux.org</updatecontact>
  <url type="homepage">https://jetbrains.com/mono/</url>
  <releases>
    <release version="%{version}-%{release}" date="$(date -d @$SOURCE_DATE_EPOCH -u --rfc-3339=d)"/>
  </releases>${fontnames}${fontlangs}
</component>
EOF_APPSTREAM

%install
install -m 0755 -vd %buildroot%_fontsdir/otf/jetbrains-mono/
cp fonts/otf/JetBrainsMono-*.otf %buildroot%_fontsdir/otf/jetbrains-mono/

(

  IFS= lines=$(
    for fontconfng in '%SOURCE10'; do
      gen-fontconf -x "${fontconfng}" -w -f 'fonts/otf/JetBrainsMono-Bold.otf' 'fonts/otf/JetBrainsMono-BoldItalic.otf' 'fonts/otf/JetBrainsMono-ExtraBold.otf' 'fonts/otf/JetBrainsMono-ExtraBoldItalic.otf' 'fonts/otf/JetBrainsMono-ExtraLight.otf' 'fonts/otf/JetBrainsMono-ExtraLightItalic.otf' 'fonts/otf/JetBrainsMono-Italic.otf' 'fonts/otf/JetBrainsMono-Light.otf' 'fonts/otf/JetBrainsMono-LightItalic.otf' 'fonts/otf/JetBrainsMono-Medium.otf' 'fonts/otf/JetBrainsMono-MediumItalic.otf' 'fonts/otf/JetBrainsMono-Regular.otf' 'fonts/otf/JetBrainsMono-SemiBold.otf' 'fonts/otf/JetBrainsMono-SemiBoldItalic.otf' 'fonts/otf/JetBrainsMono-Thin.otf' 'fonts/otf/JetBrainsMono-ThinItalic.otf'
    done
  )
  while IFS= read -r line; do
    [[ -n $line ]] && newfontconfs+=("$line")
  done <<< ${lines}

  install -m 0755 -vd "%{buildroot}%{_fontconfig_templatedir}" \
                    "%{buildroot}%{_fontconfig_confdir}"
  for fontconf in  "${newfontconfs[@]}"; do
    if [[ -n $fontconf ]] ; then
      install -m 0644 -vp "${fontconf}" "%{buildroot}%{_fontconfig_templatedir}"
      echo \"%{_fontconfig_templatedir}/$(basename "${fontconf}")\"                  >> "jetbrains-mono-fonts0.list"
      ln -vsr "%{buildroot}%{_fontconfig_templatedir}/$(basename "${fontconf}")" "%{buildroot}%{_fontconfig_confdir}"
      echo "%%config(noreplace)" \"%{_fontconfig_confdir}/$(basename "${fontconf}")\" >> "jetbrains-mono-fonts0.list"
    fi
  done
)

install -m 0755 -vd "%{buildroot}%{_metainfodir}"
install -m 0644 -vp 'org.altlinux.jetbrains-mono-fonts.metainfo.xml' "%{buildroot}%{_metainfodir}"

install -m 0755 -vd %buildroot%_fontsdir/ttf/jetbrains-mono/
cp fonts/ttf/JetBrainsMonoNL-*.ttf %buildroot%_fontsdir/ttf/jetbrains-mono/

(

  IFS= lines=$(
    for fontconfng in '%SOURCE11'; do
      gen-fontconf -x "${fontconfng}" -w -f 'fonts/ttf/JetBrainsMonoNL-Bold.ttf' 'fonts/ttf/JetBrainsMonoNL-BoldItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraBold.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraBoldItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraLight.ttf' 'fonts/ttf/JetBrainsMonoNL-ExtraLightItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Italic.ttf' 'fonts/ttf/JetBrainsMonoNL-Light.ttf' 'fonts/ttf/JetBrainsMonoNL-LightItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Medium.ttf' 'fonts/ttf/JetBrainsMonoNL-MediumItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Regular.ttf' 'fonts/ttf/JetBrainsMonoNL-SemiBold.ttf' 'fonts/ttf/JetBrainsMonoNL-SemiBoldItalic.ttf' 'fonts/ttf/JetBrainsMonoNL-Thin.ttf' 'fonts/ttf/JetBrainsMonoNL-ThinItalic.ttf'
    done
  )
  while IFS= read -r line; do
    [[ -n $line ]] && newfontconfs+=("$line")
  done <<< ${lines}

  install -m 0755 -vd "%{buildroot}%{_fontconfig_templatedir}" \
                    "%{buildroot}%{_fontconfig_confdir}"
  for fontconf in  "${newfontconfs[@]}"; do
    if [[ -n $fontconf ]] ; then
      install -m 0644 -vp "${fontconf}" "%{buildroot}%{_fontconfig_templatedir}"
      echo \"%{_fontconfig_templatedir}/$(basename "${fontconf}")\"                  >> "jetbrains-mono-nl-fonts1.list"
      ln -vsr "%{buildroot}%{_fontconfig_templatedir}/$(basename "${fontconf}")" "%{buildroot}%{_fontconfig_confdir}"
      echo "%%config(noreplace)" \"%{_fontconfig_confdir}/$(basename "${fontconf}")\" >> "jetbrains-mono-nl-fonts1.list"
    fi
  done
)

install -m 0755 -vd "%{buildroot}%{_metainfodir}"
install -m 0644 -vp 'org.altlinux.jetbrains-mono-nl-fonts.metainfo.xml' "%{buildroot}%{_metainfodir}"


%files -n fonts-otf-jetbrains-mono -f jetbrains-mono-fonts0.list
%doc OFL.txt
%doc Changelog.md README.md
%_metainfodir/org.altlinux.jetbrains-mono-fonts.metainfo.xml
%_fontsdir/otf/jetbrains-mono/*.otf

%files -n fonts-ttf-jetbrains-mono-nl -f jetbrains-mono-nl-fonts1.list
%doc OFL.txt
%doc Changelog.md README.md
%_metainfodir/org.altlinux.jetbrains-mono-nl-fonts.metainfo.xml
%_fontsdir/ttf/jetbrains-mono/*.ttf

%changelog
