%def_disable snapshot

%define ver_major 3.3
%define rdn_name com.github.johnfactotum.Foliate
# https://github.com/johnfactotum/foliate-js.git
%define fjs_ver 052123b

%def_enable check

Name: foliate
Version: %ver_major.0
Release: alt1

Summary: A simple and modern GTK eBook reader
License: GPL-3.0
Group: Office
Url: https://github.com/johnfactotum/foliate

Vcs: https://github.com/johnfactotum/foliate.git

%if_disabled snapshot
Source: %url/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif
Source1: %name-js-%fjs_ver.tar

BuildArch: noarch

%define adw_api_ver 1
%define adw_ver 1.7
%define webkit_api_ver 6.0
%define webkit_ver 2.40.1
%define gjs_ver 1.76

Requires: libgjs >= %gjs_ver dconf
#Recommends: espeak, espeak-ng or festival

Requires: typelib(Adw) = %adw_api_ver
Requires: typelib(WebKit) = %webkit_api_ver

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson
BuildRequires: libgjs-devel
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: pkgconfig(webkitgtk-6.0) >= %webkit_ver
%{?_enable_check:BuildRequires: desktop-file-utils /usr/bin/appstreamcli /usr/bin/glib-compile-schemas}

%description
Foliate is a simple and modern GTK eBook reader with following features:
- View EPUB, Kindle, FictionBook, Comic book and plain text files
- Two-page view and scrolled view
- Customize font and line-spacing
- Light, sepia, dark, and invert mode
- Reading progress slider with chapter marks
- Bookmarks and annotations
- Find in book
- Quick dictionary lookup

%prep
%setup -a1
mv %name-js-%fjs_ver/* src/%name-js

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name %rdn_name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%rdn_name.desktop
%_datadir/%rdn_name/
%_iconsdir/hicolor/symbolic/apps/%rdn_name-symbolic.svg
%_iconsdir/hicolor/scalable/apps/%rdn_name.svg
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README*


%changelog
