%global _unpackaged_files_terminate_build 1
%def_disable check
# Disabled by upstream.
# EBPF support.
%def_without ebpf
# Apache Avro encoding support.
%def_without avro
# Apache Arrow support.
%def_without arrow
# Jemalloc support (memory allocator).
%def_with jemalloc

Name: fluent-bit
Version: 4.1.1
Release: alt1

Summary: Fast data collector for Linux

License: Apache-2.0
Group: Monitoring
Url: https://github.com/fluent/fluent-bit
Vcs: https://github.com/fluent/fluent-bit

Packager: Leontiy Volodin <lvol@altlinux.org>

Source: %name-%version.tar
Patch0: %name-%version-%release.patch
# Fix up some install paths in CMake. Not upstream
Patch1: 0002-CMake-fix-up-install-paths.patch
# Add -fPIC to jemalloc build. Not upstream
Patch2: 0003-jemalloc-add-fPIC-to-CFLAGS.patch

ExcludeArch: armh ppc64le

BuildRequires(pre): rpm-macros-cmake
# Automatically added by buildreq on Mon Nov 18 2024
# optimized out: cmake-modules glibc-kernheaders-generic glibc-kernheaders-x86 libgpg-error libp11-kit libsasl2-3 libssl-devel pkg-config python3-base sh5
BuildRequires: gcc-c++ cmake flex libbacktrace-devel libcares-devel libedit-devel libluajit-devel libnghttp2-devel libpq-devel librdkafka-devel libsystemd-devel libyaml-devel libsqlite3-devel libmsgpack-c-devel libzstd-devel
BuildRequires: libssl-devel libsasl2-devel
# libudev-devel BR is needed for systemd input plugin
BuildRequires: libudev-devel
%if_with jemalloc
BuildRequires: libjemalloc-devel
%endif
%if_with arrow
BuildRequires: libarrow-glib-devel
%endif
%if_with ebpf
BuildRequires: clang-devel libbpf-devel liblzma-devel
%endif
%if_enabled check
BuildRequires: ctest
%endif
# temporarily in-source (by upstream)
# BuildRequires: libsqlite3-devel

%description
Fluent Bit is a fast Log Processor and Forwarder.
Its part of the Fluentd Ecosystem and a CNCF sub-project.
Fluent Bit allows to collect log events or metrics from different sources,
process them and deliver them to different backends such as
Fluentd, Elasticsearch, NATS, InfluxDB or any custom HTTP end-point within
others.
In addition, Fluent Bit comes with full Stream Processing capabilities:
data manipulation and analytics using SQL queries.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
sed -i 's|c-ares|cares|' \
    cmake/cares.cmake

%build
# gcc14
%add_optflags -Wno-error=incompatible-pointer-types
%cmake \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DPACKAGE_VERSION=%version \
    -DENABLE_LIB_ONLY=Off \
    -DFLB_EXAMPLES=Off \
    -DFLB_OUT_SLACK=Off \
    -DFLB_IN_SYSTEMD=On \
    -DFLB_OUT_TD=Off \
    -DFLB_OUT_ES=On \
    -DFLB_OUT_PGSQL=On \
    -DFLB_OUT_KAFKA=On \
    -DFLB_IN_KAFKA=On \
    -DFLB_IN_BLOB=On \
    -DFLB_SHARED_LIB=Off \
    -DFLB_PREFER_SYSTEM_LIBS=On \
    -DFLB_TESTS_RUNTIME=On \
    -DFLB_TESTS_INTERNAL=Off \
    -DFLB_RELEASE=On \
    -DFLB_DEBUG=Off \
    -DFLB_TLS=On \
    -DFLB_LUAJIT=On \
    -DFLB_FILTER_LUA=On \
    -DFLB_HTTP_SERVER=On \
    -DFLB_CONFIG_YAML=On \
%if_with jemalloc
    -DFLB_JEMALLOC=On \
%endif
%if_with arrow
    -DFLB_ARROW=On \
%endif
%if_with avro
    -DFLB_AVRO_ENCODER=On \
%endif
%if_with ebpf
    -DFLB_IN_EBPF=On \
%endif
%ifarch loongarch64
    -DFLB_WASM=Off \
%endif
#

%cmake_build

%install
%cmake_install
# We don't ship headers and shared library for plugins (yet)
rm -rvf %buildroot%_includedir

%check
cd %_cmake__builddir
ctest

%post
%post_service %name.service

%preun
%preun_service %name.service

%files
%doc LICENSE README.md MAINTAINERS.md CODE_OF_CONDUCT.md CONTRIBUTING.md GOLANG_OUTPUT_PLUGIN.md GOVERNANCE.md
%doc conf
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/*.conf
%_bindir/%name
%_unitdir/%name.service

%changelog
