Name: flexdock
Version: 1.2.5
Release: alt1
Epoch: 1
Summary: Docking framework for Java Swing GUI apps

#Licence is MIT on their website
License: MIT 
Group: Development/Java
URL: http://forge.scilab.org/index.php/p/flexdock/
VCS: https://gitlab.com/scilab/forge/flexdock

Source0: %name-master.tar.gz
Patch0: flexdock-use-libraries.patch

BuildRequires(pre): rpm-macros-java
BuildRequires: /proc rpm-build-java
BuildRequires: java-devel
BuildRequires: ant
BuildRequires: jpackage-utils
BuildRequires: jgoodies-common
BuildRequires: jgoodies-looks
BuildRequires: skinlf

Requires: java
Requires: jpackage-utils
Requires: jgoodies-common
Requires: jgoodies-looks
Requires: skinlf

BuildArch: noarch

%description
FlexDock is a Java docking framework for use in cross-platform
Swing applications.

%prep
%setup -n %name-master
%patch0 -p1

#Override the build file's default hard-coded paths
echo "sdk.home=%{java_home}" > workingcopy.properties

#JAR "dependency" handling
find ./ -name \*.jar -exec rm {} \;
build-jar-repository -s -p lib skinlf jgoodies-looks jgoodies-common

#Remove the jmf-using demo files
rm src/java/demo/org/flexdock/demos/raw/jmf/MediaPanel.java
rm src/java/demo/org/flexdock/demos/raw/jmf/JMFDemo.java

#Endline convert Doc files
for i in "LICENSE.txt README release-notes.txt" ;
do
    sed -i 's/\r//' $i
done

# Set minimal version
subst 's|"1\.5"|"11"|g' build.xml

# Fix package version
subst 's|VERSION.*|VERSION = "%version";|' src/java/core/org/flexdock/util/Utilities.java

%build
ant jar

%install
mkdir -p %{buildroot}%{_javadir}
install -pm644 build/%{name}-%{version}.jar %{buildroot}%{_javadir}/%{name}.jar

%files
%doc LICENSE.txt README release-notes.txt
%{_javadir}/*

%changelog
