%define _localstatedir %_var
%define _libexecdir %_prefix/libexec

%define xdg_name org.freedesktop.Flatpak
%define api_ver 1.0

%def_enable p2p
%def_enable docs
%def_enable gtk_doc
%def_disable selinux
%def_enable system_dbus_proxy
%def_enable systemd
# cannot run bwrap in hasher
%def_disable check

Name: flatpak
Version: 1.16.1
Release: alt1

Summary: Application deployment framework for desktop apps
Group: Development/Tools
License: LGPL-2.1-or-later
Url: https://flatpak.org/

Vcs: https://github.com/flatpak/flatpak.git
# Source-url: https://github.com/flatpak/flatpak/releases/download/%version/%name-%version.tar.xz
Source: %name-%version.tar
Patch1: flatpak-1.16.1-alt-flatpak.sh.patch

%define flatpak_group %name
%define flatpak_user %name

%define glib_ver 2.60
%define ostree_ver 2020.8
%define bwrap_ver 0.11.0
%define libarchive_ver 2.8.0
%define zstd_ver 0.8.1
%define malcontent_ver 0.4.0
%define curl_ver 7.29
%define appstream_ver 0.12
%define dbus_proxy_ver 0.1.6

Requires: lib%name = %version-%release
Requires: %_bindir/fusermount3
Requires: %_bindir/bwrap
Requires: bubblewrap >= %bwrap_ver
%{?_enable_system_dbus_proxy:Requires: xdg-dbus-proxy}
Requires: ostree >= %ostree_ver
Requires: dconf
Requires: fuse3
Requires: p11-kit-server

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-systemd
BuildRequires: meson socat
BuildRequires: gtk-doc gobject-introspection-devel
BuildRequires: pkgconfig(gio-unix-2.0) >= %glib_ver
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(libarchive) >= %libarchive_ver
BuildRequires: pkgconfig(libcurl) >= %curl_ver
BuildRequires: pkgconfig(ostree-1) >= %ostree_ver
BuildRequires: pkgconfig(polkit-gobject-1) /usr/bin/pkcheck
BuildRequires: pkgconfig(libseccomp)
BuildRequires: pkgconfig(appstream) >= %appstream_ver
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(gdk-pixbuf-2.0)
BuildRequires: pkgconfig(xau)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(dconf)
BuildRequires: libattr-devel
BuildRequires: libcap-devel
BuildRequires: libgpgme-devel
BuildRequires: libfuse3-devel
BuildRequires: udev-rules
BuildRequires: %_bindir/bwrap
BuildRequires: bubblewrap >= %bwrap_ver
BuildRequires: pkgconfig(wayland-protocols)
BuildRequires: pkgconfig(wayland-client) /usr/bin/wayland-scanner
%{?_enable_system_dbus_proxy:BuildRequires: xdg-dbus-proxy >= %dbus_proxy_ver}
%{?_enable_systemd:BuildRequires: pkgconfig(systemd)}
%{?_enable_selinux:BuildRequires: selinux-policy-devel}
BuildRequires: %_bindir/xsltproc
%{?_enable_docs:BuildRequires: %_bindir/xmlto docbook-dtds docbook-style-xsl}
BuildRequires: /proc
%{?_enable_check:BuildRequires: dbus %_bindir/fusermount %_bindir/ostree}
# since 1.10.0 (optional  dependencies)
BuildRequires: pkgconfig(libzstd) >= %zstd_ver
BuildRequires: pkgconfig(malcontent-0) >= %malcontent_ver
# variant-schema-compiler
BuildRequires: python3-module-pyparsing

%description
Flatpak is a system for building, distributing and running sandboxed desktop
applications on Linux. See https://wiki.gnome.org/Projects/SandboxedApps for
more information.

%package -n lib%name
Summary: Libraries for %name
Group: Development/Other
License: LGPL-2.1-or-later
Requires: %_bindir/bwrap

%description -n lib%name
This package contains libflatpak.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/Other
License: LGPL-2.1-or-later
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains the pkg-config file and development headers for %name.

%package -n lib%name-devel-doc
Summary: Development package for lib%name
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name < %version

%description -n lib%name-devel-doc
This package contains developer documentation for lib%name.

%prep
%setup
%patch1 -b .sh

%build
%meson \
    -Dsystem_bubblewrap=%_bindir/bwrap \
    -Dsystem_fusermount=%_bindir/fusermount3 \
    %{subst_enable_meson_feature docs docbook_docs} \
    %{subst_enable_meson_feature gtk_doc gtkdoc} \
    %{subst_enable_meson_feature selinux selinux_module} \
    %{subst_enable_meson_feature systemd systemd} \
    %if_with systemd
    -Dsystemdsystemunitdir=%_unitdir \
    -Dsystemduserunitdir=%_userunitdir \
    -Dsysusersdir=%_sysusersdir \
    -Dsystemdsystemenvgendir=%_env_gen_dir \
    -Dtmpfilesdir=%_tmpfilesdir \
    %endif
    %{?_enable_system_dbus_proxy:-Dsystem_dbus_proxy=%_bindir/xdg-dbus-proxy}
%nil
%meson_build

%install
%meson_install
# The system repo is not installed by the flatpak build system.
install -d %buildroot%_localstatedir/lib/flatpak

%find_lang %name

%pre
%_sbindir/groupadd -r -f %flatpak_group 2>/dev/null ||:
%_sbindir/useradd -r -N -g %flatpak_group -d / \
	-s /sbin/nologin -c "User for flatpak system helper" %flatpak_user 2>/dev/null ||:

%post
# Create an (empty) system-wide repo.
%_bindir/flatpak remote-list --system >/dev/null 2>&1 ||:

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_bindir/%name-bisect
%_bindir/%name-coredumpctl
%_datadir/bash-completion/completions/%name
%_datadir/fish/vendor_conf.d/%name.fish
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/system-services/%xdg_name.SystemHelper.service
%_datadir/%name
%_datadir/polkit-1/actions/%xdg_name.policy
%_datadir/polkit-1/rules.d/%xdg_name.rules
%_libexecdir/%name-portal
%{?_without_system_dbus_proxy:%_libexecdir/%name-dbus-proxy}
%_libexecdir/%name-session-helper
%_libexecdir/%name-system-helper
%_libexecdir/%name-validate-icon
%_libexecdir/revokefs-fuse
%_libexecdir/%name-oci-authenticator
%dir %_localstatedir/lib/%name
%_man1dir/%{name}*.1*
%attr(0755,root,root) %_sysconfdir/profile.d/%name.sh
%_sysconfdir/dbus-1/system.d/%xdg_name.SystemHelper.conf
%_datadir/dbus-1/interfaces/org.freedesktop.portal.Flatpak.xml
%_datadir/dbus-1/services/org.freedesktop.portal.Flatpak.service
%_datadir/dbus-1/interfaces/org.freedesktop.Flatpak.Authenticator.xml
%_datadir/dbus-1/services/org.flatpak.Authenticator.Oci.service

%if_enabled systemd
%_unitdir/%name-system-helper.service
%_userunitdir/%name-portal.service
%_userunitdir/%name-session-helper.service
%_sysusersdir/%name.conf
%_env_gen_dir/60-%name-system-only
%_user_env_gen_dir/60-%name
%_userunitdir/%name-oci-authenticator.service
%_tmpfilesdir/%name.conf
%endif

%_man5dir/*
%_datadir/fish/vendor_completions.d/%name.fish
%_datadir/zsh/site-functions/_%name

%doc NEWS README.md
%{?_enable_docs:%doc %_docdir/%name/}

%files -n lib%name
%_libdir/lib%name.so.*
%_typelibdir/Flatpak-%api_ver.typelib

%files -n lib%name-devel
%_includedir/%name/
%_libdir/lib%name.so
%_pkgconfigdir/%name.pc
%_datadir/dbus-1/interfaces/%xdg_name.xml
%_girdir/Flatpak-%api_ver.gir

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/%name
%endif


%changelog
