%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%def_with wayland

Name: flameshot
Version: 13.3.0
Release: alt1

Summary: Powerful yet simple to use screenshot software

License: GPLv3
Group: Graphics
URL: https://flameshot.org
VCS: https://github.com/flameshot-org/flameshot

Source: %name-%version.tar
Source1: Qt-Color-Widgets-3.0.0.tar.gz
Source2: kdsingleapplication-1.2.0.tar.gz

Packager: Anton Shevtsov <x09@altlinux.org>

BuildRequires: qt6-base-devel qt6-tools-devel qt6-svg-devel cmake
%if_with wayland
BuildRequires: kf6-kguiaddons-devel
%endif
BuildRequires: /proc

%description
Powerful and simple to use screenshot software with built-in
editor with advanced features.

%prep
%setup -a1 -a2

# Move dependencies to external folder
mkdir external
mv Qt-Color-Widgets-3.0.0 external/Qt-Color-Widgets
mv KDSingleApplication-1.2.0 external/KDSingleApplication

%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -name '*.cpp' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%cmake \
%if_with wayland
    -DUSE_WAYLAND_CLIPBOARD:BOOL=ON \
%endif
    -DCMAKE_BUILD_TYPE=Release

%cmake_build

%install
%cmake_install

%files
%doc LICENSE README.md
%_bindir/%name
%_datadir/applications/org.flameshot.Flameshot.desktop
%_datadir/bash-completion/completions/%name
%_datadir/fish/vendor_completions.d/flameshot.fish
%_datadir/zsh/site-functions/_%name
%_datadir/dbus-1/interfaces/org.flameshot.Flameshot.xml
%_datadir/dbus-1/services/org.flameshot.Flameshot.service
%_datadir/%name
%_iconsdir/hicolor/128x128/apps/org.flameshot.Flameshot.png
%_iconsdir/hicolor/48x48/apps/org.flameshot.Flameshot.png
%_iconsdir/hicolor/scalable/apps/org.flameshot.Flameshot.svg
%_iconsdir/hicolor/128x128/apps/%name.png
%_iconsdir/hicolor/48x48/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/metainfo/org.flameshot.Flameshot.metainfo.xml
%_man1dir/flameshot.1.xz

%changelog
