# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: file
Version: 5.46
Release: alt2
Summary: File type guesser
License: BSD-2-Clause
Group: File tools
Url: http://www.darwinsys.com/file/
# Sources archive: ftp://ftp.astron.com/pub/file/
Vcs: https://github.com/file/file

Source: %name-%version.tar
BuildRequires: bzlib-devel
BuildRequires: libcap-devel
BuildRequires: liblzma-devel
BuildRequires: libseccomp-devel
BuildRequires: libzstd-devel
BuildRequires: zlib-devel
%{?!_without_check:%{?!_disable_check:
BuildRequires: lzip
BuildRequires: ncompress
BuildRequires: strace
}}

%description
The file command is "a file type guesser", that is, a command-line tool that
tells you in words what kind of data a file contains. Unlike most GUI systems,
command-line UNIX systems - with this program leading the charge - don't rely
on filename extensions to tell you the type of a file, but look at the file's
actual contents. This is, of course, more reliable, but requires a bit of I/O.

%package -n libmagic
Summary: Shared library for handling magic files
Group: System/Libraries

%description -n libmagic
This package contains shared library for handling magic files.

%package -n libmagic-devel
Summary: Development files to build applications that handle magic files
Group: Development/C
Requires: libmagic = %EVR

%description -n libmagic-devel
This package contains development files to build applications that handle
magic files.

%prep
%setup

sed -i '/rm -fr magic/d' magic/Makefile.am

%build
%autoreconf
%configure \
	--enable-fsect-man5 \
	--disable-rpath \
	--disable-static
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_sysconfdir
cat <<EOF > %buildroot%_sysconfdir/magic
# Magic local data for file(1) command.
# Insert here your local magic data. Format is described in magic(5).

EOF
cat magic/magic/* > %buildroot%_datadir/file/magic

xz -k ChangeLog

%check
set -o pipefail
strace_file() {
	local ret=0
	strace -nfo strace.log -- src/file "$@" > stdout.log || ret=$?
	! grep -w -e ENOSYS strace.log >&2 || ret=$?
	# Check seccomp was enabled.
	grep -q 'prctl(PR_SET_NO_NEW_PRIVS, 1,.* = 0' strace.log
	grep -q 'seccomp(SECCOMP_SET_MODE_FILTER,.* = 0' strace.log
	# Check capabilities are dropping.
	grep -q 'capset(.*{effective=0, permitted=0, inheritable=0}.* = 0' strace.log
	# Print output to stderr for debugging.
	cat stdout.log >&2
	# Finally, print to stdout for grep.
	cat stdout.log
	return $ret
}
strace_file -m /dev/null	  ChangeLog.xz | grep ': data'
strace_file -m magic/magic/	  ChangeLog.xz | grep ': XZ compressed data'
strace_file -m magic/magic.mgc	  ChangeLog.xz | grep ': XZ compressed data'
strace_file -m magic/magic.mgc -z ChangeLog.xz | grep ': ASCII text (XZ compressed data'
# Zstd is built-in.
tar cf ChangeLog.tar.zst ChangeLog.xz --zstd
strace_file -m magic/magic.mgc -z ChangeLog.tar.zst | grep ': POSIX tar archive (GNU) (Zstandard compressed data'
# lzip uses external helper.
lzip -k ChangeLog
strace_file -m magic/magic.mgc    ChangeLog.lz | grep ': lzip compressed data'
strace_file -m magic/magic.mgc -z ChangeLog.lz | grep ': ASCII text (lzip compressed data'
%ifnarch armh
# compress does not work on armh: https://bugzilla.altlinux.org/43803
# Z uses external helper (gzip).
compress ChangeLog
strace_file -m magic/magic.mgc    ChangeLog.Z  | grep ': compress.d data'
strace_file -m magic/magic.mgc -z ChangeLog.Z  | grep ': ASCII text (compress.d data'
%endif

make check

%files
%doc COPYING README.md ChangeLog.xz
%config(noreplace) %_sysconfdir/magic
%_bindir/file
%_datadir/file
%_man1dir/file.1*
%_man5dir/magic.5*

%files -n libmagic
%_libdir/libmagic.so.*

%files -n libmagic-devel
%_includedir/magic.h
%_libdir/libmagic.so
%_pkgconfigdir/libmagic.pc
%_man3dir/libmagic.3*

%changelog
