%define sover 4

Name: ffmpegthumbnailer
Version: 2.2.3
Release: alt1

Summary: Lightweight video thumbnailer that can be used by file managers
License: GPL-2.0
Group: Graphics

URL: https://github.com/dirkvdb/ffmpegthumbnailer
VCS: https://github.com/dirkvdb/ffmpegthumbnailer.git

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libavformat-devel
BuildRequires: libjpeg-devel
BuildRequires: libpng-devel
BuildRequires: libswscale-devel
BuildRequires: libswresample-devel
BuildRequires: libavfilter-devel
BuildRequires: libpostproc-devel

%description
Lightweight video thumbnailer that can be used by file managers.

This video thumbnailer can be used to create thumbnails for your
video files. The thumbnailer uses ffmpeg to decode frames from the
video files, so supported videoformats depend on the configuration
flags of ffmpeg.

This thumbnailer was designed to be as fast and lightweight as
possible. The only dependencies are ffmpeg, libpng and libjpeg.

The project also includes a C/C++ library that can be used by
developers to generate thumbnails in their projects.

%package -n lib%name%sover
Summary: Shared libraries for ffmpegthumbnailer
Group: System/Libraries
Obsoletes: lib%name < 2.2.3

%description -n lib%name%sover
This package includes a shared libraries for ffmpegthumbnailer

%package -n lib%name-devel
Summary: Include Files and Libraries mandatory for Development
Group: Development/C++
Requires: lib%name%sover = %EVR
Requires: libavutil-devel
Requires: libavformat-devel
Requires: libavcodec-devel
Requires: libswscale-devel

%description -n lib%name-devel
This package includes C/C++ libraries that can be used by
developers to generate thumbnails in their projects.

%prep
%setup
%patch -p1

%build
%cmake -DCMAKE_BUILD_TYPE=Release -DENABLE_GIO=ON -DENABLE_THUMBNAILER=ON
%cmake_build

%install
%cmake_install

%files
%doc AUTHORS ChangeLog README
%_bindir/%name
%_datadir/thumbnailers
%_man1dir/*

%files -n lib%name%sover
%_libdir/lib%name.so.%sover
%_libdir/lib%name.so.%sover.*

%files -n lib%name-devel
%_libdir/lib%name.so
%_includedir/lib%name
%_pkgconfigdir/*.pc

%changelog
