Name: fetchmail
Version: 6.4.37
Release: alt1.1

Summary: Full-featured POP/IMAP/ETRN mail retrieval daemon
License: GPL-2.0-or-later
Group: Networking/Mail
Url: http://www.fetchmail.info

Source0: %name-%version.tar

Patch0001: 0001-Add-missing-space-in-config-option.patch
Patch0002: 0002-Add-option-to-switch-off-permission-check.patch
Patch0003: 0003-Do-not-check-libssl-version.patch
Patch0004: 0004-Fix-LFS-on-32-bit-systems.patch
Patch0005: fetchmail_alt_no_future.patch

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define rtdir %_runtimedir/%name

BuildRequires(pre): rpm-build-python3
BuildRequires: flex
BuildRequires: libkrb5-devel
BuildRequires: openssl-devel
BuildRequires: python3-devel

Requires: %_sbindir/sendmail
Requires: setup >= 2.1.9-ipl15mdk
Requires: service >= 0.5.28-alt1

%description
Fetchmail is a free, full-featured, robust, and well-documented
remote mail retrieval and forwarding utility intended to be used
over on-demand TCP/IP links (such as SLIP or PPP connections).

It retrieves mail from remote mail servers and forwards it to
your local (client) machine's delivery system, so it can then be
read by normal mail user agents such as Mutt, Elm, Pine,
(X)Emacs/Gnus or Mailx.

Fetchmail supports every remote-mail protocol currently in use on
the Internet (POP2, POP3, RPOP, APOP, KPOP, all IMAPs, ESMTP
ETRN) for retrieval.  Then Fetchmail forwards the mail through
SMTP or a mail delivery agent (MDA) program of your choice, so
you can read it through your normal mail client.

You may also want to install and configure a local SMTP server,
such as postfix-smtpd, as that's what fetchmail uses for delivery
by default.

%package -n %{name}conf
Summary: A utility for graphically configuring your %name preferences
Group: System/Configuration/Networking
Requires: %name = %version-%release, tkinter

%package daemon
Summary: SySV init script for demonize %name for sucking emails
Group: System/Servers
PreReq: %name = %version-%release
PreReq: shadow-utils, chkconfig
BuildArch: noarch

%package contrib
Summary: Various contributed software designed to work with %name
Group: System/Base
Requires: %name = %version-%release
BuildArch: noarch

%package locales
Summary: %name localization
Group: System/Internationalization
Requires: %name = %version-%release
BuildArch: noarch

%description -n %{name}conf
Fetchmailconf is a TCL/TK application for graphically configuring
your ~/.%{name}rc preferences file.

Fetchmail has many options which can be daunting to the new user.

This utility takes some of the guesswork and hassle out of
setting up %name.

%description daemon
SySV init script for demonize %name for sucking emails.

%description contrib
Various contributed software designed to work with %name.

%description locales
As there were problems with %name localization, it was disabled;
this package can be used to re-add message translations if deemed
neccessary.

%prep
%setup
%autopatch -p1

cp -a .rpm/fetchmailrc.example fetchmailrc.example

sed -i 's|@pythondir@/fetchmailconf.py|%python3_sitelibdir/fetchmailconf.py|'\
	Makefile.am

%build
export PYTHON=%__python3
export ac_cv_path_procmail=%_bindir/procmail
export ac_cv_path_sendmail=%_sbindir/sendmail
export ac_cv_lib_intl_gettext=no
export CPPFLAGS=-I%_includedir/krb5

%autoreconf

%configure \
	--enable-fallback=sendmail \
	--enable-RPA \
	--enable-NTLM \
	--enable-SDPS \
	--with-ssl \
	--with-gssapi \
	--with-kerberos5 \
	--without-kerberos
%make_build

%install
%makeinstall

rm -rf contrib/RCS

install -pDm755 .rpm/%name.init %buildroot%_initdir/%name
install -pDm644 .rpm/%name.service %buildroot%_unitdir/%name.service
touch %buildroot%_sysconfdir/%{name}rc

install -pDm644 .rpm/fetchmailconf-large.png %buildroot%_liconsdir/%{name}conf.png
install -pDm644 .rpm/fetchmailconf-mini.png  %buildroot%_miconsdir/%{name}conf.png
install -pDm644 .rpm/fetchmailconf.png       %buildroot%_niconsdir/%{name}conf.png
install -pDm644 .rpm/fetchmailconf.desktop   %buildroot%_desktopdir/%{name}conf.desktop

mkdir -p %buildroot%rtdir

cat >README.%name-conf <<EOF
Fetchmailconf is a TCL/TK application for graphically configuring your
~/.fetchmailrc preferences file.

Fetchmail has many options which can be daunting to the new user.

This utility takes some of the guesswork and hassle out of setting up
fetchmail.
EOF

%find_lang %name

%if "%python3_sitelibdir" != "%python3_sitelibdir_noarch"
    mkdir -p %buildroot%python3_sitelibdir
    mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

%check
make check

%pre -n %name-daemon
%_sbindir/groupadd -r -f %name ||:
%_sbindir/useradd -r -n -M -g %name -d %rtdir -s /dev/null %name &>/dev/null ||:

%triggerpostun -n %name-daemon -- fetchmail-daemon <= 6.3.9-alt1
usermod -d %rtdir %name ||:

%post -n %name-daemon
%post_service %name

%preun -n %name-daemon
%preun_service %name

%files
%_bindir/%name
%_man1dir/%name.*
%doc COPYING NEWS README README.SSL *.html *.txt
%doc fetchmailrc.example

%files -n %{name}conf
%_bindir/%{name}conf
%python3_sitelibdir/*
%_desktopdir/*.desktop
%_niconsdir/*.png
%_liconsdir/*.png
%_miconsdir/*.png
%_man1dir/%{name}conf.*

%files daemon
%_initdir/%name
%_unitdir/%name.service
%attr(640,root,%name) %config(noreplace,missingok) %_sysconfdir/%{name}rc
%attr(775,root,%name) %rtdir

%files contrib
%doc contrib/*

%files -f %name.lang locales

%changelog
