%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define libname libfeedback
%define xdg_name org.sigxcpu.Feedback
%define ver_major 0.8
%define namespace Lfb
%define api_ver 0.0

%def_enable introspection
%def_enable vala
%def_enable man
%def_disable gtk_doc
%def_enable check

Name: feedbackd
Version: %ver_major.6
Release: alt1

Summary: Feedback library for GNOME
Group: System/Servers
License: GPL-3.0-or-later and LGPL-2.1-or-later
Url: https://source.puri.sm/Librem5/feedbackd

Vcs: https://gitlab.freedesktop.org/agx/feedbackd.git

%if_disabled snapshot
Source: https://gitlab.freedesktop.org/agx/feedbackd/-/archive/v%version/%name-v%version.tar.gz
%else
Source: %name-%version.tar
%endif

Requires: %libname = %EVR
#Requires: feedbackd-device-themes

%define glib_ver 2.66
%define gudev_ver 232
%define gmobile_ver 0.2.0

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson
BuildRequires: pkgconfig(gio-2.0) >= %glib_ver
BuildRequires: pkgconfig(gsound)
BuildRequires: pkgconfig(gudev-1.0) >= %gudev_ver
BuildRequires: pkgconfig(udev)
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(systemd)
BuildRequires: pkgconfig(gmobile) >= %gmobile_ver
BuildRequires: pkgconfig(umockdev-1.0)
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_man:BuildRequires: /usr/bin/rst2man}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_check:BuildRequires: dbus-tools-gui}

%description
feedbackd provides a DBus daemon (feedbackd) to act on events to provide
haptic, visual and audio feedback. It offers a library (libfeedback) and
GObject introspection bindings to ease using it from applications.

%package -n %libname
Summary: Library for %name
License: LGPL-2.1-or-later
Group: System/Libraries

%description -n %libname
The lib%name package contains libraries for %name

%package -n %libname-devel
Summary: Development files for %libname
License: LGPL-2.1-or-later
Group: Development/C
Requires: %libname = %EVR

%description -n %libname-devel
The %name-devel package contains libraries and header files for
developing applications that use %libname.

%package -n %libname-gir
Summary: GObject introspection data for %libname
Group: System/Libraries
Requires: %libname = %EVR

%description -n %libname-gir
GObject introspection data for %libname

%package -n %libname-gir-devel
Summary: GObject introspection devel data for %libname
Group: Development/Other
BuildArch: noarch
Requires: %libname-gir = %EVR
Requires: %libname-devel = %EVR

%description -n %libname-gir-devel
GObject introspection devel data for %libname

%prep
%setup -n %name-%{?_disable_snapshot:v}%version
# ALT #47557
sed -i 's|-G %name|-G users|' data/72-feedbackd.rules

%build
%meson \
    %{subst_enable_meson_feature introspection introspection} \
    %{subst_enable_meson_bool vala vapi} \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_bool man man}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_bindir/fbcli
%_bindir/fbd-theme-validate
%_libexecdir/%name
%_libexecdir/fbd-alert-slider
%_libexecdir/fbd-ledctrl
%_userunitdir/fbd-alert-slider.service
%_udevrulesdir/72-%name.rules
%_datadir/dbus-1/interfaces/%xdg_name.xml
%_datadir/dbus-1/interfaces/%xdg_name.Haptic.xml
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/%name/
%_datadir/glib-2.0/schemas/org.sigxcpu.feedbackd.gschema.xml
%{?_enable_man:%_man1dir/fbcli.1.*
%_man1dir/fbd-theme-validate.1.*
%_man5dir/feedback-themes.5.*
%_man8dir/%name.8.*}

%files -n %libname
%_libdir/%libname-%api_ver.so.*

%files -n %libname-devel
%_includedir/%libname-%api_ver/
%_libdir/%libname-%api_ver.so
%_pkgconfigdir/%libname-%api_ver.pc
%{?_enable_vala:%_datadir/vala/vapi/%libname-%api_ver.*}

%if_enabled introspection
%files -n %libname-gir
%_typelibdir/%namespace-%api_ver.typelib

%files -n %libname-gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%changelog
